#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <TimeSource/Datum.h>

extern "C" {
#include "bc635lib.h"
}

#include <utils/ConfigFile.h>

TimeSource* create_TimeSource_datum(TimeSourceGenerator*,
                                    utils::ConfigFile* params,
                                    utils::SymbolTable*)
{
  const char* device = params->getString("device", "/dev/bc635");
  int fd = open(device, O_RDONLY);
  if (fd == -1) {
    fprintf(stderr, "Datum Time Source: Unable to open %s\n", device);
    return NULL;
  }
  printf("***Using DATUM time source at port %s***\n", device);
  return new DatumTimeSource(fd);
}

DatumTimeSource::DatumTimeSource(int fd)
{
  _fd = fd;
}

DatumTimeSource::~DatumTimeSource()
{
  close(_fd);
}

bool DatumTimeSource::getTime(utils::Time& t)
{
  struct timeval tv;
  if (bc635_gettimeofday(_fd, &tv) == -1) {
    fprintf(stderr, "Datum Time Source:  Error getting time\n");
    return false;
  }
  t.setValue(tv.tv_sec, tv.tv_usec);
  
  return true;
}

