#ifndef INTF_STATUS_SOURCE
#define INTF_STATUS_SOURCE

#include <utils/Interface.h>
#include <utils/Time.h>
#include <utils/String.h>
#include <ConfigSource/ConfigSource.h>

#define STATUS_BLOCKING true
#define STATUS_NONBLOCKING false

UTILS_INTERFACE(StatusSource) {
 public:
  StatusSource() {}
  virtual ~StatusSource() {}

  typedef ConfigSource::ModuleState ModuleState;

  struct Status {
    utils::Time last_update;
    utils::Time last_run;
    ModuleState state;
    float status, confidence, avg_cycle_time;
    const char* msg;
  };

  class ModuleStatus {
  public:
    ModuleStatus(const char* name) { _name = name; }
    virtual ~ModuleStatus() {}

    virtual bool getStatus(Status&, bool blocking = STATUS_NONBLOCKING) = 0;

    const char* name() const { return _name.getString(); }

  private:
    utils::String _name;
  };

  virtual ModuleStatus* moduleStatus(const char* module_name) = 0;
  virtual void closeModuleStatus(ModuleStatus*) = 0;

  UTILS_INTF_DECL(StatusSource);
};

#endif
