//
// $Id: utils.cc,v 1.2 2003/10/09 20:15:44 jayg Exp $
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS OR A PARTICULAR PURPOSE. See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston MA
// 02111-1307, USA.
//
// This file uses PERCEPS style comments to facilitate automatic
// documentation generation. More information on PERCEPS can be
// found at "http://starship.python.net/crew/tbryan/PERCEPS".
//
// Author: Ross J. Micheals
//         rmicheals@lehigh.edu
//
// (c) 1999-2000 Ross J. Micheals

#include <SPU-Toolbox/utils.h>

void u8u8_to_u16(SPU_u16& dest, 
		 const SPU_u8& byte0, const SPU_u8& byte1) {
  dest = ((byte0 << 8) & 0xff00) | (byte1 & 0x00ff);
  return;
}

void u8u8_to_s16(SPU_s16& dest,
		 const SPU_u8& byte0, const SPU_u8& byte1) {
  dest = ((byte0 << 8) & 0xff00) | (byte1 & 0x00ff);
  return;
}

void u16_to_u8u8(SPU_u8& dest0, SPU_u8& dest1, const SPU_u16& word) {
  dest0 = (word >> 8) & 0x00ff;
  dest1 = word & 0x00ff;
  return;
}

void u16_to_u8u8(SPU_u8* dest, int i, const SPU_u16& word) {
  u16_to_u8u8(dest[i], dest[i+1], word);
}

void s16_to_u8u8(SPU_u8& dest0, SPU_u8& dest1, const SPU_s16& word) {
  dest0 = (word >> 8) & 0x00ff;
  dest1 = word & 0x00ff;
  return;
}

void s16_to_u8u8(SPU_u8* dest, int i, const SPU_s16& word) {
  s16_to_u8u8(dest[i], dest[i+1], word);
}

void u16_to_u8_lsb_X4(SPU_u8& u8_0, SPU_u8& u8_1, 
		      SPU_u8& u8_2, SPU_u8& u8_3,
		      const SPU_u16 src) {
  u8_0 |= ((src & 0xf000) >> 12) & 0x0f;
  u8_1 |= ((src & 0x0f00) >>  8) & 0x0f;
  u8_2 |= ((src & 0x00f0) >>  4) & 0x0f;
  u8_3 |= ((src & 0x000f) >>  0) & 0x0f;
  return;
}

void u16_to_u8_lsb_X4(SPU_u8* dest, int i, const SPU_u16 src) {
  u16_to_u8_lsb_X4(dest[i], dest[i+1], dest[i+2], dest[i+3], src);
  return;
}

void s16_to_u8_lsb_X4(SPU_u8& u8_0, SPU_u8& u8_1, 
		      SPU_u8& u8_2, SPU_u8& u8_3,
		      const SPU_s16 src) {
  u8_0 |= ((src & 0xf000) >> 12) & 0x0f;
  u8_1 |= ((src & 0x0f00) >>  8) & 0x0f;
  u8_2 |= ((src & 0x00f0) >>  4) & 0x0f;
  u8_3 |= ((src & 0x000f) >>  0) & 0x0f;
  return;
}

void s16_to_u8_lsb_X4(SPU_u8* dest, int i, const SPU_s16 src) {
  u16_to_u8_lsb_X4(dest[i], dest[i+1], dest[i+2], dest[i+3], src);
  return;
}


void u8_lsb_X4_to_u16(SPU_u16& dest,
		      const SPU_u8& u8_0, const SPU_u8& u8_1, 
		      const SPU_u8& u8_2, const SPU_u8& u8_3) {
  SPU_u16 u16_0 = 0x000f & u8_0; u16_0 = (u16_0 << 12) & 0xf000;
  SPU_u16 u16_1 = 0x000f & u8_1; u16_1 = (u16_1 <<  8) & 0x0f00;
  SPU_u16 u16_2 = 0x000f & u8_2; u16_2 = (u16_2 <<  4) & 0x00f0;
  SPU_u16 u16_3 = 0x000f & u8_3; u16_3 = (u16_3 <<  0) & 0x000f;
  dest = u16_0 | u16_1 | u16_2 | u16_3;
  return;
}

void u8_lsb_X4_to_u16(SPU_u16& dest, int i, const SPU_u8* const src) {
  u8_lsb_X4_to_u16(dest, src[i], src[i+1], src[i+2], src[i+3]);
  return;
}

void u8_lsb_X4_to_s16(SPU_s16& dest,
		      const SPU_u8& u8_0, const SPU_u8& u8_1, 
		      const SPU_u8& u8_2, const SPU_u8& u8_3) {
  SPU_u16 u16_0 = 0x000f & u8_0; u16_0 = (u16_0 << 12) & 0xf000;
  SPU_u16 u16_1 = 0x000f & u8_1; u16_1 = (u16_1 <<  8) & 0x0f00;
  SPU_u16 u16_2 = 0x000f & u8_2; u16_2 = (u16_2 <<  4) & 0x00f0;
  SPU_u16 u16_3 = 0x000f & u8_3; u16_3 = (u16_3 <<  0) & 0x000f;
  dest = static_cast<SPU_s16>(u16_0 | u16_1 | u16_2 | u16_3);
  return;
}

void u8_lsb_X4_to_s16(SPU_s16& dest, int i, const SPU_u8* const src) {
  u8_lsb_X4_to_s16(dest, src[i], src[i+1], src[i+2], src[i+3]);
  return;
}


void u8_lsb_X2_to_u8(SPU_u8& dest, const SPU_u8& u8_0, const SPU_u8& u8_1) {
  dest = ((u8_0 & 0x0f) << 4) | ((u8_0 & 0x0f)); 
  return;
}

void u8_lsb_X2_to_u8(SPU_u8* dest, int i, const SPU_u8& src) {
  u8_lsb_X2_to_u8(dest[i], dest[i+1], src);
  return;
}

void u8_to_u8_lsb_X2(SPU_u8& u8_0, SPU_u8& u8_1, const SPU_u8& src) {
  u8_0 |= ((src & 0xf0) >>  4) & 0x0f;
  u8_1 |= ((src & 0x0f) >>  0) & 0x0f;
  return;
}

void u8_to_u8_lsb_X2(SPU_u8* dest, int i, const SPU_u8& src) {
  u8_to_u8_lsb_X2(dest[i], dest[i+1], src);
  return;
}

int 
SPU_verbose_mutex_lock(pthread_mutex_t *mutex)
{
  int status = pthread_mutex_lock(mutex);
  if (status == EINVAL) {
    cerr << "*** MUTEX ERROR ***: Mutex not properly initialized."
	 << endl;
    abort();
  }
  if (status == EDEADLK) {
    cerr << "*** MUTEX ERROR ***: Mutex already locked by calling thread."
	 << endl;
    abort();
  }
  return(status);
}

int 
SPU_verbose_mutex_unlock(pthread_mutex_t *mutex)
{
  int status = pthread_mutex_unlock(mutex);
  if (status == EINVAL) {
    cerr << "*** MUTEX ERROR ***: Mutex not properly initialized."
	 << endl;
    abort();
  }
  if (status == EPERM) {
    cerr << "*** MUTEX ERROR ***: Calling thread does not own mutex."
	 << endl;
    abort();
  }
  return(status);
}

bool 
extract_ip_display_head(char* disp_str, SPU_u8 idh[6])
{

  char* str = strdup(disp_str);

  int colon_index = -1;
  int dot_index   = -1;

  // Look for a ":" and terminate the string there.
  for (int i=0; i < (int) strlen(str); i++) {
    if (str[i] == ':') {
      colon_index = i;
      str[i] = '\0';
    }
  }
  
  // We did not find a ":". Return in failure.
  if (colon_index == -1) return(false);
  
  // Could there be a "."?
  if ((int) strlen(str) >= colon_index + 3) {
    for (int i=colon_index+1; i < (int) strlen(str); i++)
      if (str[i] == '.') {
	dot_index = i;
	str[i] = '\0';
      }
  }
  
  // Assign the display number.
  idh[4] = static_cast<SPU_u8>(atoi(&(str[colon_index+1])));
  
  // Is there a head number? If not, assume 0.
  if (dot_index != -1)
    idh[5] = static_cast<SPU_u8>(atoi(&(str[dot_index+1])));
  else 
    idh[5] = 0;

  if (!*str)
    return false;

  struct hostent* he = gethostbyname(str);
  if (!he) 
    return(false);
  
  //? Could this be a problem, just looking at the first address?
  for (int i=0; i < 4; i++) {
    idh[i] = he->h_addr_list[0][i];
  }

  free(str);
  return(true);
}

void print_ip_display_head(SPU_u8 idh[6], ostream& os) 
{
  os << static_cast<int>(idh[0]) << "." 
     << static_cast<int>(idh[1]) << "."
     << static_cast<int>(idh[2]) << "."
     << static_cast<int>(idh[3]) << ":"
     << static_cast<int>(idh[4])
     << "." 
     << static_cast<int>(idh[5]);
  return;
}

SPU_u64 ip_disp_head_to_u64(SPU_u8 idh[6]) 
{
  SPU_u64 u64_0 = static_cast<SPU_u64>(idh[0]) << 40;
  SPU_u64 u64_1 = static_cast<SPU_u64>(idh[1]) << 32;
  SPU_u64 u64_2 = static_cast<SPU_u64>(idh[2]) << 24;
  SPU_u64 u64_3 = static_cast<SPU_u64>(idh[3]) << 16;
  SPU_u64 u64_4 = static_cast<SPU_u64>(idh[4]) <<  8;
  SPU_u64 u64_5 = static_cast<SPU_u64>(idh[5]) <<  0;
  SPU_u64 u64 = u64_0 | u64_1 | u64_2 | u64_3 | u64_4 | u64_5;

  return(u64);
}

bool ip_disp_head_is_local(SPU_u8 idh[6])
{
  if (idh[0] == 127 &&
      idh[1] == 0 && 
      idh[2] == 0 && 
      idh[3] == 1)
    return(true);
  else
    return(false);
}

const char* const SPU_Toolbox_version(void) {
  return(c_SPU_Toolbox_version_string);
}

int 
SPU_Toolbox_version_major_number(void)
{
  return(c_SPU_Toolbox_major_number);
}

int 
SPU_Toolbox_version_minor_number(void)
{
  return(c_SPU_Toolbox_minor_number);
}

int 
SPU_Toolbox_version_release_number(void)
{
  return(c_SPU_Toolbox_release_number);
}

void SPU_no_op(void) { };





