//
// $Id: utils.h,v 1.1 2002/12/02 19:38:53 jayg Exp $
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS OR A PARTICULAR PURPOSE. See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston MA
// 02111-1307, USA.
//
// This file uses PERCEPS style comments to facilitate automatic
// documentation generation. More information on PERCEPS can be
// found at "http://starship.python.net/crew/tbryan/PERCEPS".
//
// Author: Ross J. Micheals
//         rmicheals@lehigh.edu
//
// (c) 1999-2000 Ross J. Micheals

#ifndef __SPU_Toolbox__included__utils_h__
#define __SPU_Toolbox__included__utils_h__

#include <SPU-Toolbox/SPU-Types.h>
#include <iostream.h>

extern "C" {
#include <X11/Xlib.h>
#include <string.h>
#include <stdlib.h>
#include <netdb.h>
}

#include <SPU-Toolbox/config.h>

const char* const c_SPU_Toolbox_version_string = SPU_VERSION_STRING;

const int c_SPU_Toolbox_major_number   = SPU_MAJOR_VERSION_NUMBER;
const int c_SPU_Toolbox_minor_number   = SPU_MINOR_VERSION_NUMBER;
const int c_SPU_Toolbox_release_number = SPU_RELEASE_VERSION_NUMBER;

void u8u8_to_u16(SPU_u16&, const SPU_u8&, const SPU_u8&);
void u8u8_to_s16(SPU_s16&, const SPU_u8&, const SPU_u8&);

void u16_to_u8u8(SPU_u8&, SPU_u8&, const SPU_u16&);
void u16_to_u8u8(SPU_u8*, int, const SPU_u16&);

void s16_to_u8u8(SPU_u8&, SPU_u8&, const SPU_s16&);
void s16_to_u8u8(SPU_u8*, int, const SPU_s16&);

void u16_to_u8_lsb_X4(SPU_u8&, SPU_u8&, SPU_u8&, SPU_u8&, const SPU_u16);
void u16_to_u8_lsb_X4(SPU_u8*, int, const SPU_u16);

void s16_to_u8_lsb_X4(SPU_u8&, SPU_u8&, SPU_u8&, SPU_u8&, const SPU_s16);
void s16_to_u8_lsb_X4(SPU_u8*, int, const SPU_s16);

// LSB functions for Visca mostly

void u8_lsb_X4_to_u16(SPU_u16&, 
		      const SPU_u8&, const SPU_u8&, 
		      const SPU_u8&, const SPU_u8&);
void u8_lsb_X4_to_u16(SPU_u16&, int, const SPU_u8* const);

void u8_lsb_X4_to_s16(SPU_s16&, 
		      const SPU_u8&, const SPU_u8&, 
		      const SPU_u8&, const SPU_u8&);
void u8_lsb_X4_to_s16(SPU_s16&, int, const SPU_u8* const);

void u8_lsb_X2_to_u8(SPU_u8&, const SPU_u8&, const SPU_u8&);
void u8_lsb_X2_to_u8(SPU_u8*, int, const SPU_u8&);

void u8_to_u8_lsb_X2(SPU_u8&, SPU_u8&, const SPU_u8&);
void u8_to_u8_lsb_X2(SPU_u8*, int, const SPU_u8&);

int SPU_verbose_mutex_lock(pthread_mutex_t*);
int SPU_verbose_mutex_unlock(pthread_mutex_t*);

bool extract_ip_display_head(char* disp_str, SPU_u8 idh[6]);
bool ip_disp_head_is_local(SPU_u8 idh[6]);
void print_ip_display_head(SPU_u8 idh[6], ostream& os);
SPU_u64 ip_disp_head_to_u64(SPU_u8 idh[6]);
const char * const SPU_Toolbox_version(void);

int SPU_Toolbox_version_major_number();
int SPU_Toolbox_version_minor_number();
int SPU_Toolbox_version_release_number();

void SPU_no_op(void);

#endif







