// ---------------------------------------------------------------
// SPU-Toolbox
//
//        File: color-utils.h
// Description: Utility functions for handling color issues
// ---------------------------------------------------------------
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS OR A PARTICULAR PURPOSE. See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston MA
// 02111-1307, USA.
//
// This file may use Doxgen style comments to facilitate automatic
// documentation generation. More information on PERCEPS can be
// found at "http://www.stack.nl/~dimitri/doxygen/index.html".
//
// Author: Ross J. Micheals
//         rjm2@eecs.lehigh.edu
//
// (c) 1999-2001 Ross J. Micheals

/*!
  
  \file   color-utils.h
  \brief  Utility functions for handling color issues
  \author Ross J. Micheals (rjm2@cse.lehigh.edu)

*/

#ifndef __SPU_Toolbox__included__color_utils_h__
#define __SPU_Toolbox__included__color_utils_h__

#include <SPU-Toolbox/config.h>
#include <SPU-Toolbox/SPU-Types.h>

#include <iostream.h>

extern "C" {
#include <string.h>
#if SPU_HAVE_LIBIPL == 1
#include <ipl/ipl.h>
#endif
}

bool color_utils_init_statics();
static bool color_utils_static_initialization_hack=color_utils_init_statics();

static const char* const short_SPU_Color_Format_strings[] = 
{
  "grey8",
  "grey16",
  "grey32",

  "rgb1555",
  "rgb5155",
  "rgb5515",
  "rgb5551",

  "bgr1555",
  "bgr5155",
  "bgr5515",
  "bgr5551",

  "rgb565",
  "bgr565",

  "rgb24",
  "bgr24",
  
  "msb_rgb32",
  "lsb_rgb32",

  "msb_bgr32",
  "lsb_bgr32",
  
  "yuv422_planar",
  "yuv422_packed",

  "",
  "unknown"
};

static const char* const long_SPU_Color_Format_strings[] =
{
  "8-bit greyscale",
  "16-bit greyscale",
  "32-bit greyscale",

  "15-bit RGB (1555)",
  "15-bit RGB (5155)",
  "15-bit RGB (5515)",
  "15-bit RGB (5551)",

  "15-bit BGR (1555)",
  "15-bit BGR (5155)",
  "15-bit BGR (5515)",
  "15-bit BGR (5551)",

  "16-bit RGB",
  "16-bit BGR",

  "24-bit RGB",
  "24-bit BGR",

  "MSB-padded RGB32",
  "LSB-padded RGB32",
  "MSB-padded BGR32",
  "LSB-padded BGR32",

  "Planar YUV422",
  "Packed YUV422",

  "",
  "UNKNOWN"
};


SPU_Color_Format 
str_to_SPU_Color_Format(const char* const& str);

const char* const 
SPU_Color_Format_to_str(const SPU_Color_Format& cf);

const char* const 
SPU_Color_Format_to_long_str(const SPU_Color_Format& cf);

int 
bytes_per_pixel(const SPU_Color_Format& cf);

#if SPU_HAVE_LIBIPL

SPU_Color_Format
ipl_Color_Format_to_SPU_Color_Format(int nChannels,
				     int depth, 
				     char* colorModel,
				     char* channelSeq,
				     int dataOrder);

bool
SPU_Color_Format_to_ipl_Color_Format(const SPU_Color_Format cf,
				     int& nChannels,
				     int& depth,
				     char*& colorModel,
				     char*& channelSeq,
				     int& dataOrder);

#endif

#endif // __SPU_Toolbox__included__color_utils_h__

