//
// $Id: color-convert.h,v 1.3 2004/10/09 15:22:35 jayg Exp $
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS OR A PARTICULAR PURPOSE. See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston MA
// 02111-1307, USA.
//
// This file may use PERCEPS style comments to facilitate automatic
// documentation generation. More information on PERCEPS can be
// found at "http://starship.python.net/crew/tbryan/PERCEPS".
//
// Author: Ross J. Micheals
//         rmicheals@lehigh.edu
//
// (c) 1999-2000 Ross J. Micheals

#include <SPU-Toolbox/config.h>
#include <SPU-Toolbox/SPU-Types.h>

#include <string.h>
#include <iostream.h>

bool SPU_init_colconv(void);

SPU_color_convert_FP 
SPU_get_colconv_fp(const SPU_Color_Format& icf, const SPU_Color_Format& ocf);

void Grey8_to_RGB565                   (SPU_u8*, int, SPU_u8*, int, int, int);
void Grey8_to_BGR565                   (SPU_u8*, int, SPU_u8*, int, int, int);
void Grey8_to_RGB24                    (SPU_u8*, int, SPU_u8*, int, int, int);
void Grey8_to_BGR_RAW_888              (SPU_u8*, int, SPU_u8*, int, int, int);
void Grey8_to_MSBPadded_RGB32          (SPU_u8*, int, SPU_u8*, int, int, int);

void RGB1555_to_RGB565                 (SPU_u8*, int, SPU_u8*, int, int, int);

void RGB565_to_Grey8                   (SPU_u8*, int, SPU_u8*, int, int, int);
void RGB565_to_BGR565                  (SPU_u8*, int, SPU_u8*, int, int, int);
void RGB565_to_RGB24                   (SPU_u8*, int, SPU_u8*, int, int, int);
void RGB565_to_BGR24                   (SPU_u8*, int, SPU_u8*, int, int, int);
void RGB565_to_MSBPadded_RGB32         (SPU_u8*, int, SPU_u8*, int, int, int);
void RGB565_to_LSBPadded_RGB32         (SPU_u8*, int, SPU_u8*, int, int, int);
void RGB565_to_MSBPadded_BGR32         (SPU_u8*, int, SPU_u8*, int, int, int);
void RGB565_to_LSBPadded_BGR32         (SPU_u8*, int, SPU_u8*, int, int, int);

void BGR565_to_Grey8                   (SPU_u8*, int, SPU_u8*, int, int, int);
void BGR565_to_RGB565                  (SPU_u8*, int, SPU_u8*, int, int, int);
void BGR565_to_RGB24                   (SPU_u8*, int, SPU_u8*, int, int, int);
void BGR565_to_BGR24                   (SPU_u8*, int, SPU_u8*, int, int, int);
void BGR565_to_MSBPadded_RGB32         (SPU_u8*, int, SPU_u8*, int, int, int);
void BGR565_to_LSBPadded_RGB32         (SPU_u8*, int, SPU_u8*, int, int, int);
void BGR565_to_MSBPadded_BGR32         (SPU_u8*, int, SPU_u8*, int, int, int);
void BGR565_to_LSBPadded_BGR32         (SPU_u8*, int, SPU_u8*, int, int, int);

void RGB24_to_Grey8                    (SPU_u8*, int, SPU_u8*, int, int, int);
void RGB24_to_RGB565                   (SPU_u8*, int, SPU_u8*, int, int, int);
void RGB24_to_BGR565                   (SPU_u8*, int, SPU_u8*, int, int, int);
void RGB24_to_BGR24                    (SPU_u8*, int, SPU_u8*, int, int, int);
void RGB24_to_MSBPadded_RGB32          (SPU_u8*, int, SPU_u8*, int, int, int);
void RGB24_to_LSBPadded_RGB32          (SPU_u8*, int, SPU_u8*, int, int, int);
void RGB24_to_MSBPadded_BGR32          (SPU_u8*, int, SPU_u8*, int, int, int);
void RGB24_to_LSBPadded_BGR32          (SPU_u8*, int, SPU_u8*, int, int, int);

void BGR24_to_Grey8                    (SPU_u8*, int, SPU_u8*, int, int, int);
void BGR24_to_RGB565                   (SPU_u8*, int, SPU_u8*, int, int, int);
void BGR24_to_BGR565                   (SPU_u8*, int, SPU_u8*, int, int, int);
void BGR24_to_RGB24                    (SPU_u8*, int, SPU_u8*, int, int, int);
void BGR24_to_MSBPadded_RGB32          (SPU_u8*, int, SPU_u8*, int, int, int);
void BGR24_to_LSBPadded_RGB32          (SPU_u8*, int, SPU_u8*, int, int, int);
void BGR24_to_MSBPadded_BGR32          (SPU_u8*, int, SPU_u8*, int, int, int);
void BGR24_to_LSBPadded_BGR32          (SPU_u8*, int, SPU_u8*, int, int, int);

void MSBPadded_RGB32_to_Grey8          (SPU_u8*, int, SPU_u8*, int, int, int);
void MSBPadded_RGB32_to_RGB565         (SPU_u8*, int, SPU_u8*, int, int, int);
void MSBPadded_RGB32_to_BGR565         (SPU_u8*, int, SPU_u8*, int, int, int);
void MSBPadded_RGB32_to_RGB24          (SPU_u8*, int, SPU_u8*, int, int, int);
void MSBPadded_RGB32_to_BGR24          (SPU_u8*, int, SPU_u8*, int, int, int);
void MSBPadded_RGB32_to_LSBPadded_RGB32(SPU_u8*, int, SPU_u8*, int, int, int);
void MSBPadded_RGB32_to_MSBPadded_BGR32(SPU_u8*, int, SPU_u8*, int, int, int);
void MSBPadded_RGB32_to_LSBPadded_BGR32(SPU_u8*, int, SPU_u8*, int, int, int);

void LSBPadded_RGB32_to_Grey8          (SPU_u8*, int, SPU_u8*, int, int, int);
void LSBPadded_RGB32_to_RGB565         (SPU_u8*, int, SPU_u8*, int, int, int);
void LSBPadded_RGB32_to_BGR565         (SPU_u8*, int, SPU_u8*, int, int, int);
void LSBPadded_RGB32_to_RGB24          (SPU_u8*, int, SPU_u8*, int, int, int);
void LSBPadded_RGB32_to_BGR24          (SPU_u8*, int, SPU_u8*, int, int, int);
void LSBPadded_RGB32_to_MSBPadded_RGB32(SPU_u8*, int, SPU_u8*, int, int, int);
void LSBPadded_RGB32_to_MSBPadded_BGR32(SPU_u8*, int, SPU_u8*, int, int, int);
void LSBPadded_RGB32_to_LSBPadded_BGR32(SPU_u8*, int, SPU_u8*, int, int, int);

void MSBPadded_BGR32_to_Grey8          (SPU_u8*, int, SPU_u8*, int, int, int);
void MSBPadded_BGR32_to_RGB565         (SPU_u8*, int, SPU_u8*, int, int, int);
void MSBPadded_BGR32_to_BGR565         (SPU_u8*, int, SPU_u8*, int, int, int);
void MSBPadded_BGR32_to_RGB24          (SPU_u8*, int, SPU_u8*, int, int, int);
void MSBPadded_BGR32_to_BGR24          (SPU_u8*, int, SPU_u8*, int, int, int);
void MSBPadded_BGR32_to_MSBPadded_RGB32(SPU_u8*, int, SPU_u8*, int, int, int);
void MSBPadded_BGR32_to_LSBPadded_RGB32(SPU_u8*, int, SPU_u8*, int, int, int);
void MSBPadded_BGR32_to_LSBPadded_BGR32(SPU_u8*, int, SPU_u8*, int, int, int);

void LSBPadded_BGR32_to_Grey8          (SPU_u8*, int, SPU_u8*, int, int, int);
void LSBPadded_BGR32_to_RGB565         (SPU_u8*, int, SPU_u8*, int, int, int);
void LSBPadded_BGR32_to_BGR565         (SPU_u8*, int, SPU_u8*, int, int, int);
void LSBPadded_BGR32_to_RGB24          (SPU_u8*, int, SPU_u8*, int, int, int);
void LSBPadded_BGR32_to_BGR24          (SPU_u8*, int, SPU_u8*, int, int, int);
void LSBPadded_BGR32_to_MSBPadded_RGB32(SPU_u8*, int, SPU_u8*, int, int, int);
void LSBPadded_BGR32_to_LSBPadded_RGB32(SPU_u8*, int, SPU_u8*, int, int, int);
void LSBPadded_BGR32_to_MSBPadded_BGR32(SPU_u8*, int, SPU_u8*, int, int, int);

void YUV422_Packed_to_Grey8            (SPU_u8*, int, SPU_u8*, int, int, int);
void YUV422_Packed_to_LSBPadded_BGR32  (SPU_u8*, int, SPU_u8*, int, int, int);

void color_convert_raw         (SPU_u8*, int, SPU_u8*, int, int, int);
