//
// $Id: clamp.h,v 1.1 2002/12/02 19:38:53 jayg Exp $
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS OR A PARTICULAR PURPOSE. See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston MA
// 02111-1307, USA.
//
// This file uses PERCEPS style comments to facilitate automatic
// documentation generation. More information on PERCEPS can be
// found at "http://starship.python.net/crew/tbryan/PERCEPS".
//
// Author: Ross J. Micheals
//         rmicheals@lehigh.edu
//
// (c) 1999-2000  Ross J. Micheals

//! author = "Ross J. Micheals"

#ifndef __clamp_h__
#define __clamp_h__

template<class T> 
inline bool clamp(T& data, const T& min, const T& max) {
  if (data >= max) { data = max; return false; }
  if (data <= min) { data = min; return false; }
  return true;
}

#endif // #ifndef __clamp_h__
