// ----------------------------------------------------------------
// SPU-Toolbox
//
//        File: SPU-Types.h
// Description: Shared/global type definitions
// ----------------------------------------------------------------
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS OR A PARTICULAR PURPOSE. See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston MA
// 02111-1307, USA.
//
// This file uses Doxygen style comments to facilitate documentation
// generation. More information on Doxygen can be found at
//
// Author: Ross J. Micheals
//         rmicheals@lehigh.edu
//
// (c) 1999-2000 Ross J. Micheals

#ifndef __SPU_Toolbox__included__types_h__
#define __SPU_Toolbox__included__types_h__

// Maybe namespaces will be implemented someday . . (sigh)

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

extern "C" {
#include <pthread.h>
#include <errno.h>
}

/*! 
  \file SPU-Types.h
  \brief Shared types
 */

//! Unsigned 8-bit quantity
typedef unsigned char          SPU_u8 ;	

//! Signed 8-bit quantity
typedef   signed char          SPU_s8 ;	

//! Unsigned 16-bit quantity
typedef unsigned short         SPU_u16;

//! Signed 16-bit quantity
typedef   signed short         SPU_s16;

//! Unsigned 32-bit quantity
typedef unsigned int           SPU_u32;

//! Signed 32-bit quantity
typedef   signed int           SPU_s32;

// TODO: Check for necessity and portability of 64-bit quantities?

//! Unsigned 64-bit quantity
typedef unsigned long long int SPU_u64;

//! Signed 64-bit quantity
typedef   signed long long int SPU_s64;

typedef void (*SPU_PFv)(void);
typedef void (*SPU_PFvp)(void*);
typedef void (*SPU_color_convert_FP)
  (SPU_u8* from_p, int from_bpl, SPU_u8* to_p, int to_bpl, int w, int h);


//! Color format enumeration
enum SPU_Color_Format 
{
  SPU_Color_Format_Grey8,		/*!< 8-bit greyscale */
  SPU_Color_Format_Grey16,		/*!< 16-bit greyscale */
  SPU_Color_Format_Grey32,		/*!< 32-bit greyscale */

  SPU_Color_Format_RGB1555,		/*!< 15-bit RGB (bit 15 unused) */
  SPU_Color_Format_RGB5155,		/*!< 15-bit RGB (bit 9 unused) */
  SPU_Color_Format_RGB5515,		/*!< 15-bit RGB (bit 6 unused) */
  SPU_Color_Format_RGB5551,		/*!< 15-bit RGB (bit 0 unused) */

  SPU_Color_Format_BGR1555,		/*!< 15-bit BGR (bit 15 unused) */
  SPU_Color_Format_BGR5155,		/*!< 15-bit BGR (bit 9 unused) */
  SPU_Color_Format_BGR5515,		/*!< 15-bit BGR (bit 6 unused) */
  SPU_Color_Format_BGR5551,		/*!< 15-bit BGR (bit 0 unused) */

  SPU_Color_Format_RGB565,		/*!< 16-bit RGB */
  SPU_Color_Format_BGR565,		/*!< 16-bit BGR */

  SPU_Color_Format_RGB24,		/*!< 24-bit RGB */
  SPU_Color_Format_BGR24,		/*!< 24-bit BGR */

  SPU_Color_Format_MSBPadded_RGB32,	/*!< 32-bit RGB (MSB unused) */
  SPU_Color_Format_LSBPadded_RGB32, /*!< 32-bit RGB (LSB unused) */

  SPU_Color_Format_MSBPadded_BGR32,	/*!< 32-bit BGR (MSB unused) */
  SPU_Color_Format_LSBPadded_BGR32, /*!< 32-bit BGR (MSB unused) */
  
  SPU_Color_Format_YUV422_Planar,	/*!< Planar YUV422 */
  SPU_Color_Format_YUV422_Packed,	/*!< Packed YUV422 */

  SPU_Color_Format_COUNT,		/*!< Number of SPU_Color_Formats */
  SPU_Color_Format_Unknown		/*!< Unknown color format */

};

#endif



