// put this in a separate file to provide public access for things which need
// the names but which don't want to display anything

#include <ImgDisplay/ImgDisplay.h>

static const char* const Color_Type_strings[] = 
{
  "grey8",
  "grey16",
  "grey32",

  "rgb1555",
  "rgb5155",
  "rgb5515",
  "rgb5551",

  "bgr1555",
  "bgr5155",
  "bgr5515",
  "bgr5551",

  "rgb565",
  "bgr565",

  "rgb24",
  "bgr24",
  
  "msb_rgb32",
  "lsb_rgb32",

  "msb_bgr32",
  "lsb_bgr32",
  
  "yuv422_planar",
  "yuv422_packed",

  NULL,
  "unknown"
};

const char* ImgDisplay::colorTypeToString(ImgDisplay::ColorType type)
{
  if ((int) type < 0 || (int) type >= ImgDisplay::LastColorType)
    return NULL;

  return Color_Type_strings[(int) type];
}

ImgDisplay::ColorType ImgDisplay::stringToColorType(const char* string) 
{
  for (int i=0;Color_Type_strings[i];i++) {
    if (!strcmp(string, Color_Type_strings[i]))
      return (ImgDisplay::ColorType) i;
  }
  return ImgDisplay::UnknownColorType;
}
  

