#include <stdio.h>

#include <ConfigSource/ConfigSource.h>
#include <utils/SymbolTable.h>

static void status_change(const char* name, utils::Type type,
                          void* data, int num_elems, void* cbdata)
{
  printf("Change %s, %d, %d\n", name, type.getKey(), num_elems);
}

int main (int argc, char* argv[])
{
  utils::SymbolTable globals;
  if (argc != 2) {
    printf("Usage: server <spec>\n");
    return -1;
  }

  ConfigSource* server = ConfigSource::create(argv[1], &globals);
  if (!server) {
    printf("Could not initialize server\n");
    return -1;
  }

  server->notify("struct ModuleStatus", status_change, server);

  while (1) {
    bool res = server->processEvents(1.0);
    printf("Blip %d\n", res);
  }

  return 0;
}
