#include <ConfigSource/Repository.h>

#include <utils/SymbolTable.h>

#define REPOSITORY_NAME "RepositorySource"

static ConfigSource* _Repository = NULL;

namespace Repository {
  ConfigSource* instance(utils::SymbolTable* table)
  {
    if (_Repository)
      return _Repository;
    if (!table)
      return NULL;

    ConfigSource* repo = (ConfigSource*) table->get(REPOSITORY_NAME);
    if (repo)
      return repo;
    repo = ConfigSource::getIntf(table);
    if (!repo) {
      return NULL;
    }
    set(table, repo);
    return repo;
  }

  ConfigSource* initialize(utils::SymbolTable* table, const char* spec)
  {
    ConfigSource* repository = ConfigSource::create(spec, table);
    if (repository) 
      set(table, repository);
    return repository;
  }

  void reset(utils::SymbolTable* table) 
  {
    set(table, NULL);
  }

  void set(utils::SymbolTable* table, ConfigSource* repo)
  {
    utils::Managed::deferDeletions();
    table->set(REPOSITORY_NAME, repo, utils::SymbolTable::managedManager,
               true);
    _Repository = repo;
    utils::Managed::undeferDeletions();
  }
}    
