#include <unistd.h>

#include <utils/Time.h>
#include <utils/StructElem.h>
#include <ConfigSource/File.h>

ConfigSource* create_ConfigSource_file(ConfigSourceGenerator*,
                                       utils::ConfigFile* params,
                                       utils::SymbolTable*)
{
  FileConfigSource* intf = new FileConfigSource();
  if (!intf->open(params->getString("name", "main.conf"))) {
    delete intf;
    return NULL;
  }
  return intf;
}

bool FileConfigSource::open(const char* name)
{
  _file.close();
  _name = name;
  return (_file.open(name));
}

bool FileConfigSource::parse(const char* vals)
{
  _file.close();
  return (_file.parse(vals));
}

int FileConfigSource::get(utils::Type type, const char* name,
                          void* data, int max_num,
                          void* default_data, int num_defaults)
{
  return _file.get(type, name, data, max_num, default_data, num_defaults);
}

int FileConfigSource::numValues(const char* name)
{
  return _file.numValues(name);
}


bool FileConfigSource::attach(utils::Type type, const char* name,
                              void* data, int max_num, ConfigCallback, void*,
                              void* default_data, int num_defaults)
{
  int num = _file.get(type, name, data, max_num, default_data,
                      num_defaults);
  return (num > 0);
}
    
bool FileConfigSource::set(const char* name, const char* value)
{
  return _file.set(name, value) != NULL;
}

bool FileConfigSource::set(utils::Type type, const char* name, void* data,
                           int num_values)
{
  return _file.set(type, name, data, num_values) != NULL;
}

bool FileConfigSource::processEvents(double timeout)
{
  if (timeout == -1.0) {
    while (1) 
      sleep(1);
  } else
    if (timeout > 0) 
      utils::Time::sleep(timeout);

  return false;
}

static void reset_watch(utils::ConfigElem* dest, utils::ConfigElem* src)
{
  dest->setWatcher(src->watcher());

  if (dest->getTypeId().isDerivedFrom(utils::StructElem::getClassTypeId()) &&
      src->getTypeId().isDerivedFrom(utils::StructElem::getClassTypeId())) {
    utils::StructElem* dest_struct = (utils::StructElem*) dest;
    utils::StructElem* src_struct = (utils::StructElem*) src;
    utils::StringDictIterator<utils::ConfigElem*> iter(dest_struct->entries());
    for (utils::ConfigElem* cur = iter.first(); cur; cur = iter.next()) {
      utils::ConfigElem* elem = src_struct->lookup(iter.key());
      if (elem)
        reset_watch(cur, elem);
    }
  }
}

bool FileConfigSource::refresh()
{
  utils::ConfigElem* root = _file.getRoot();
  root->ref();

  _file.close();
  if (!_file.open(_name.getString())) {
    root->unref();
    return false;
  }

  reset_watch(_file.getRoot(), root);
  root->unref();

  return true;
}
