/** \file VehPoseDest.h
    API header file for for the VehPoseDest reconfigurable interface 
    \ref VehPoseGroup "example".
    \ingroup VehPoseGroup
*/
#ifndef VEH_POSE_DEST_INTF_H
#define VEH_POSE_DEST_INTF_H

#include <utils/Time.h>
#include <utils/Interface.h>

#include <VehPoseDest/VehPose.h>

/** \class VehPoseDest

    The VehPoseDest interface example.

    An abstract interface to output 3D road information through an STL vector
    of 3D points

    \ingroup VehPoseGroup
 */
UTILS_INTERFACE(VehPoseDest) {
 public:
  /** Empty virtual destructor for VehPoseDest.
      For C++ syntax reasons, it is a good idea to explicitly define a virtual
      destructor, even if empty like this one, to any abstract class like this.
   */
  virtual ~VehPoseDest() {}

  /** Outputs the a set of road points tagged with a time.

      \param[in] time The time at which the road information was collected.
      \param[in] veh_pose The 3D pose of the vehicle at \p time
      \return \p true if the pose has been outputted successfully.
  */
  virtual bool outputPose(utils::Time time, const VehPose& veh_pose) = 0;

  // declare the standard interface static methods
  UTILS_INTF_DECL(VehPoseDest);
};
  
#endif
