/** \file
    Implements the LoggerVehPoseDest interface instance
    \ingroup VehPoseGroup
*/

#include "VehPoseDest.h"
#include "VehPoseLogger.h"

/// Logging interface definition for VehPoseDest
class LoggerVehPoseDest : public VehPoseDest {
 public:
  /// \copydoc VehPoseDest::outputPose
  virtual bool outputPose(utils::Time time, const VehPose& veh_pose);

  /// Initialization routine
  bool init(utils::ConfigFile& params);

 private:
  VehPoseLogger _logger;  ///< the packaged logger
};

/// The required creation function for the "logger" tag
VehPoseDest* create_VehPoseDest_logger(VehPoseDestGenerator*,
                                       utils::ConfigFile* params,
                                       utils::SymbolTable* globals)
{
  LoggerVehPoseDest* intf = new LoggerVehPoseDest();
  if (!intf->init(*params)) {
    delete intf;
    return NULL;
  }
  return intf;
}

bool LoggerVehPoseDest::init(utils::ConfigFile& params)
{
  return _logger.open(params);
}

bool LoggerVehPoseDest::outputPose(utils::Time time, const VehPose& pose)
{
  return _logger.logPoints(time, pose);
}



  
