/** \file
    Implements the PlayerRoadSource interface instance
    \ingroup RoadGroup
*/
#include <iostream>

#include <utils/ConfigFile.h>
#include <TimeSource/TimeSource.h>

#include "RoadSource.h"
#include "RoadPlayer.h"

/** Player interface definition for RoadSource.
*/
class PlayerRoadSource : public RoadSource {
 public:
  /// \copydoc RoadSource::getPoints
  virtual bool getPoints(utils::Time& time,
                         std::vector<utils::Vec3d>& points,
                         bool blocking = true);

  /// Initialization routine
  bool init(utils::ConfigFile& params, utils::SymbolTable* globals);

 private:
  RoadPlayer _player;
};

/// The required creation function for the "player" tag
RoadSource* create_RoadSource_player(RoadSourceGenerator* gen,
                                     utils::ConfigFile* params,
                                     utils::SymbolTable* globals)
{
  PlayerRoadSource* intf = new PlayerRoadSource();
  if (!intf->init(*params, globals)) {
    delete intf;
    return NULL;
  }
  return intf;
}

bool PlayerRoadSource::init(utils::ConfigFile& params,
                            utils::SymbolTable* globals)
{
  return _player.open(params, globals);
}

bool PlayerRoadSource::getPoints(utils::Time& time,
                               std::vector<utils::Vec3d>& points,
                               bool blocking)
{
  return _player.nextPoints(time, points, blocking);
}

