#ifndef INTF_ROAD_STRUCTS_H
#define INTF_ROAD_STRUCTS_H

/** \addtogroup RoadGroup 
    @{
*/

/** \file
    Defines the structures for the road interface. 
*/

/** Structure for packaging a single road point
*/
struct RoadDataPoint {
  double x;  ///< X position of road point
  double y;  ///< Y position of road point
  float z;   ///< Z position of road point
};

/** Structure for packaging road data for transport
 */
struct RoadDataStruct {
  int num_points;        ///< number of road points
  RoadDataPoint* points; ///< the 3D road point list
};
    
/** Defines marshalling format for \ref RoadDataStruct */
#define ROAD_DATA_FMT "{int, < {double, double, float } : 1>}"

/** Structure for packaging road data for transport via shared memory
 */
struct RoadShmemStruct {
  int secs;  ///< Time in seconds for data
  int usecs; ///< Remaining time in microseconds for data
  RoadDataStruct data;  ///< The data
};

/** Defines marshalling format for \ref RoadShmemStruct */
#define ROAD_SHMEM_FMT "{int, int, " ROAD_DATA_FMT " }"

/** Define the default Road shared memory name */
#define ROAD_SHMEM_NAME "RoadData"

/** @} */

#endif
