/** \file
    Implements the RoadLogger class
    \ingroup RoadGroup
*/
#include <utils/Linear.h>
#include <utils/ConfigFile.h>

#include "RoadLogger.h"

bool RoadLogger::open(const char* name,
                      const utils::ConfigFile* user_header)
{
  utils::ConfigFile header;

  // copy user header information if there is any
  if (user_header) {
    utils::ConfigFile::copy(*user_header, header);
  }

  // set the data format major and minor version numbers in the header
  header.setInt("int DataFormat.version_major", 1);
  header.setInt("int DataFormat.version_minor", 0);

  // make sure logger is closed
  _logger.close();

  // hook up logger to _output_area
  _logger.declare("points", ROAD_DATA_FMT, &_output_area);

  // open the file, and return status as the result
  return _logger.open(name, header);
}

bool RoadLogger::open(utils::ConfigFile& header)
{
  return open(header.getString("name", "Road.raw"), &header);
}

bool RoadLogger::logPoints(utils::Time time,
                           const std::vector<utils::Vec3d>& points)
{
  // setup output area
  _output_area.num_points = (int) points.size();
  _output_area.points = new RoadDataPoint[_output_area.num_points];
  for (int i=0;i<_output_area.num_points;i++) {
    _output_area.points[i].x = points[i].x;
    _output_area.points[i].y = points[i].y;
    _output_area.points[i].z = points[i].z;
  }

  // log _output_area
  bool res = _logger.log(time);

  // cleanup output area
  delete [] _output_area.points;

  // return the result of the log
  return res;
}

