#include <unistd.h>
#include <string.h>

#include <ArcVoter/Print.h>
#include <utils/ConfigFile.h>

static float default_radii[] = {
    -8, -15, -20, -50, -100, 10000000, 20, 50, 100, 15, 8
};

ArcVoter* create_ArcVoter_print(ArcVoterGenerator*, utils::ConfigFile* params,
                                utils::SymbolTable* globals)
{
  const char* output_file = params->getString("file", "");
  FILE* output_fp;
  bool close_output;
  if (!*output_file) {
    close_output = false;
    output_fp = stdout;
  } else {
    output_fp = fopen(output_file, "r");
    close_output = true;
  }
  if (!output_fp) {
    return NULL;
  }

  float radii[100];
  int num_arcs =
    params->getFloats("radii", radii, 100,
                      default_radii, sizeof(default_radii)/sizeof(float));

  return new PrintArcVoter(output_fp, close_output, num_arcs, radii);
}

PrintArcVoter::PrintArcVoter(FILE* output, bool close_output,
                             int num_arcs, float* radii)
{
  _output = output;
  _close_output = close_output;

  _num_arcs = num_arcs;
  _radii = new float[num_arcs];
  memcpy(_radii, radii, num_arcs*sizeof(float));
}

PrintArcVoter::~PrintArcVoter()
{
  delete [] _radii;
  if (_close_output)
    fclose(_output);
}

int PrintArcVoter::numArcs() const
{
  return _num_arcs;
}

int PrintArcVoter::getArcs(float* radii_array, int size_array) const
{
  int size = MIN(_num_arcs, size_array);
  memcpy(radii_array, _radii, size*sizeof(float));
  return size;
}

bool PrintArcVoter::vote()
{
  printf("Arc votes:");
  float* votes = getVoteBuffer();
  for (int i=0;i<_num_arcs;i++) {
    printf(" %4.2f=%5.3f", _radii[i], votes[i]);
  }
  printf("\n");
  
  return true;
}

