#include <stdio.h>

#include "collect.h"

MyModule::MyModule(const char* spec) : Module("SickINSCollector", spec)
{
}

bool MyModule::initialize(ConfigSource* config, utils::SymbolTable* table)
{
  const char* spec;
  spec = config->getString("scanner_spec");
  _scanner = create<LineScanner>(spec);
  if (!_scanner) {
    fprintf(stderr, "MyModule: Spec '%s', creates no valid scanner\n", spec);
    return false;
  }

  spec = config->getString("veh_state_spec");
  _veh_state = create<VehState>(spec);
  if (!_veh_state) {
    fprintf(stderr, "MyModule: Spec '%s', creates no vehicle state source\n",
            spec);
    return false;
  }

  _exit_on_no_data = config->getBool("exit_on_no_data", false);

  return true;
}

bool MyModule::run()
{
  if (!_scanner->getLine(_line)) {
    if (_exit_on_no_data)
      return false;
    fprintf(stderr, "Error getting line\n");
    return true;
  }

  // get the vehicle state at start of scan
  int num = _line.numElems();
  utils::Time tag(_line[num-1].secs, _line[num-1].usecs);
  VehStateStruct cur_state;
  if (!_veh_state->getState(tag, cur_state)) {
    if (_exit_on_no_data)
      return false;
    fprintf(stderr, "Error getting vehicle state\n");
    return true;
  }

  // do something with it here

  return true;
}

MODULE_MAIN(collect, MyModule);
