#include <stdio.h>
#include <ctype.h>    
#include "send.h"
#include "start.h"

usage_exit(name)
    char *name;
{
    fprintf(stderr,"Usage: %s [-S -v -i] <startup file> [<tag>] [<tag>] ...\n",
            name);
    exit(-1);
}

main(argc,argv)
    int argc;
    char **argv;
{
    int i;
    int do_startup = FALSE;
    int start_verbose = 0;
    int interactive = FALSE;

    init_send(argc,argv);
    
    for (i=1;(i < argc) && (*argv[i] == '-');i++) {
        switch (*(argv[i]+1)) {
          case 'S':
            do_startup = TRUE;
            break;
          case 'v':
            start_verbose = TRUE;
            break;
	  case 'i':
	    interactive = TRUE;
	    break;
          default:
            usage_exit(argv[0]);
        }
    }

    /* run interactive - never acknowledge do_startup flag; always set to false! */

    if (interactive) { 
        startup_interactive_from_file(argv[i],&argv[i+1],argc-i-1,FALSE,start_verbose);
	exit(0);
    }

    if (i==argc)
        usage_exit(argv[0]);

    if (do_startup)
        startup_from_file(argv[i],&argv[i+1],argc-i-1,1,start_verbose);
    startup_from_file(argv[i],&argv[i+1],argc-i-1,0,start_verbose);
}

do_verbose(file_name,tags,num_tags,do_startup)
    char *file_name;
    char **tags;
    int num_tags;
    int do_startup;
{
    int i;

    printf("Loading file %s\n",file_name);
    if (num_tags) {
	printf("Using %d tags: ",num_tags);
	for (i=0;i<num_tags;i++)
	printf("`%s' ",tags[i]);
	printf("\n");
    } else
        printf("Using no tags\n");
        
    if (do_startup)
    printf("Only doing window startup\n");
}

startup_from_file(file_name, tags, num_tags,do_startup, verbose)
    char *file_name;
    char **tags;
    int num_tags;
    int do_startup;
    int verbose;
{
    int i;
    STATE_TYPE state;
    FILE *fp;
    int lineno;
    char c;
    char str[MAX_STRING+1];
    char window_name[MAX_STRING+1];
    char options[MAX_STRING+1];
    char cur_tag[MAX_STRING+1];
    WINDOW *cur_window;
    int window_is_set_up = FALSE;
    int quoted;

    if (verbose) 
        do_verbose(file_name,tags,num_tags,do_startup);

    fp = fopen(file_name,"r");
    if (!fp) {
        perror("Opening startup file");
        exit(-1);
    }

    state = INITIAL;

    lineno = 1;
    while ((c = getc(fp)) != EOF) {
        if (c == '\n') {
            lineno++;
	    continue;
	}

        if (isspace(c)) 
            continue;

        if (c == COMMENT_CHAR) {
            skip_line(fp);
            lineno++;
            continue;
        }

        if (c == '(') {
            switch (state) {
              case NAMED:
                state = OPTION;
                break;
              case COMMAND:
                state = TAG;
                break;
              default:
                syntax_error(lineno);
            }
            continue;
        }

        if (c == ')'){
            switch (state) {
              case OPTION_READ:
                state = NAMED;
                break;
              case GOT_COMMAND:
                state = INSIDE;
                break;
              default:
                syntax_error(lineno);
            }
            continue;
        }

        if (c == '{') {
            switch (state) {
              case NAMED:
                state = INSIDE;
                window_is_set_up = FALSE;
                break;
              default:
                syntax_error(lineno);
            }
            continue;
        }

        if (c == '}') {
            switch (state) {
              case INSIDE:
                state = INITIAL;
                break;
              default:
                syntax_error(lineno);
            }
            continue;
        }

        if (c == ',') {
            switch (state) {
              case TAG_COMMA:
                state = GET_COMMAND;
                break;
              default:
                syntax_error(lineno);
            }
            continue;
        }

        lineno += read_string(fp,c,str,MAX_STRING,&quoted);
        switch (state) {
          case INITIAL:
	    if (!strcasecmp(INCLUDE_STRING,str)) {
		state = INCLUDE;
		break;
	    }
	    strcpy(window_name,str);
	    *options = '\0';
	    state = NAMED;
            break;
	  case INCLUDE:
	    startup_from_file(str,tags,num_tags,do_startup,verbose);
	    state = INITIAL;
	    break;
          case OPTION:
            strcpy(options,str);
            state = OPTION_READ;
            break;
          case INSIDE:
            if (strcmp(COMMAND_STRING,str))
                syntax_error(lineno);
            state = COMMAND;
            break;
          case COMMAND:
            if (num_tags == 0) {
                if (!window_is_set_up) {
                    window_is_set_up = TRUE;
                    cur_window = setup_window(window_name,options,
                                              do_startup,verbose);
                }
                if (!do_startup)
                    send_command(cur_window,str,quoted,verbose);
            }
            state = INSIDE;
            break;
          case TAG:
            strcpy(cur_tag,str);
            state = TAG_COMMA;
            break;
          case GET_COMMAND:
            if (tag_matches(cur_tag,tags,num_tags)) {
                if (!window_is_set_up) {
                    window_is_set_up = TRUE;
                    cur_window = setup_window(window_name,options,
                                              do_startup,verbose);
                }
                if (!do_startup)
                    send_command(cur_window,str,quoted,verbose);
            }
            state = GOT_COMMAND;
            break;
          default:
            syntax_error(lineno);
        }
        continue;
    }
}

syntax_error(lineno)
    int lineno;
{
    fprintf(stderr,"Syntax error at line number %d\n",lineno);
    exit(-1);
}

skip_line(fp)
    FILE *fp;
{
    char c;
    
    do {
        c = getc(fp);
        if (c == EOF)
            return;
    } while (c != '\n');
}

int process_char(c, state, str)
    char c;
    int state;
    char *str;
{
    if (state == PLAIN) {
        if (c == '^')
            state = CARET;
        else if (c == '\\')
            state = SLASH;
        else
            *str = c;
    } else {
        if (state == CARET) {
            if (c == '[')
                c = 27;
            else
                c -= 'A'-1;
        } else {
            switch (c) {
              case 'n':
                c = '\n'; break;
              case 't':
                c = '\t'; break;
            }
        }
        *str = c;
        state = PLAIN;
    }
    return(state);
}
            
int read_string(fp,first_char,str,max_string,quoted)
    FILE *fp;
    char first_char;
    char *str;
    int max_string;
    int *quoted;
{
    char c;
    int i;
    int lineno = 0;
    int state = PLAIN;

    i = 0;
    if (first_char == '"') {
        *quoted = 1;
        for (i=0;i<max_string;i++) {
            c = getc(fp);
            if (c == '\n')
                lineno++;
            if ((c == EOF) || (state != SLASH && c == '"')) {
                *str = '\0';
                return(lineno);
            }

            state = process_char(c, state, str);
            if (state == PLAIN)
                str++;
        }

        fprintf(stderr,"Warning: string size exceeded\n");
        return(lineno);
    }

    *quoted = 0;
    *str++ = first_char;
    for (i=1;i<max_string;i++) {
        c = getc(fp);
        if (c == EOF) 
            break;
        if (isspace(c) || (c=='(') || (c=='{') || (c==',') || (c==')') ||
            (c == '}') || (c == COMMENT_CHAR)) {
            ungetc(c,fp);
            break;
        }
        state = process_char(c, state, str);
        if (state == PLAIN)
            str++;
    }
    *str = '\0';
    if (i >= max_string)
        fprintf(stderr,"Warning: string size exceeded\n");
    return(0);
}
    
int tag_matches(tag,tag_list,num_tags)
    char *tag;
    char **tag_list;
    int num_tags;
{
    int i;

    if (!strcmp(tag,"wildcard"))
        return(TRUE);
    
    for (i=0;i<num_tags;i++)
        if (!strcmp(tag,*tag_list++))
            return(TRUE);
    
    return(FALSE);
}
           
            
