#ifndef REPOMON_H
#define REPOMON_H

#include <list>

#include <utils/String.h>
#include <ConfigSource/Module.h>

class StatusSource;
class ConfigSource;
class RepoMonInterface;
class MonitorIntf;
class Fl_Box;

class RepoMon : public Module
{
 public:
  RepoMon(const char* spec);
  virtual ~RepoMon();
  virtual bool initialize(ConfigSource* config, utils::SymbolTable* table);
  virtual bool run();

  void load_modules();
  void clear_modules();
  void finish();
  void refresh_config();

private:
  StatusSource* _status_source;
  ConfigSource* _repository;
  RepoMonInterface* _repomon_intf;
  double _interval;
  bool _finished;
  std::list<MonitorIntf*> _modules;
  utils::String* _hosts;
};

#endif
