
/*
 *      wsearch.c 
 *      
 *      Routines for a depth-first search
 *      of a display's window hierarchy.
 *
 *      Written for Advanced X Window Applications Programming
 *
 */


#include  "xbook.h"


Window SearchWindowTree( display, parent, starting_window, level, compare_func )

Display *display;
Window  parent;
Window  starting_window;        /* -- Where we start */
int     level;                  /* -- How far down are we? */
Window  (*compare_func)();      /* -- is this the one? */

/*
 *      SearchWindowTree() performs a depth-first search of
 *      all the windows in the display's window hierarchy, until
 *      compare_func() returns a non-null (non-None)
 *      window.  Until that point, SearchWindowTree()
 *      will call itself recursively going down the
 *      window tree.  compare_func() is called with:
 *      display, parent window, window, level.
 */

{       /* -- function SearchWindowTree */
        Window  window, rootwindow, window_parent;
        int     num_children, status, i;
        Window  *children;

        /*
         *      First check the easy case,
         *      Is this window the one
         *      we are looking for?
         */
        window = (compare_func)(display, 
                        parent,
                        starting_window, level );

        if ( window != (Window)None )
                {
                return( window );
                }

        /*
         *      Ok, we haven't found it yet.
         *      Now, search down the window tree
         *      in a depth-first fashion.
         */
        children = (Window *)NULL;

        status   = XQueryTree(  display, 
                                starting_window,
                                &rootwindow, 
                                &window_parent,
                                &children, 
                                &num_children );
        
        if ( status == 0 )
                {
                /*
                 *      No more children,
                 *      or cannot get Window
                 *      Tree
                 */
                return( (Window) None );
                }

        /*
         *      Check the children
         */
        i = 0;

        while( ( i < num_children ) && 
            ( window == (Window) None ) )
                {
                window = SearchWindowTree( display,
                                starting_window,        /* -- parent */
                                children[ i ],
                                level + 1,
                                compare_func );

                i++;
                }

        /*
         *      Return memory resources
         *      to the Operating
         *      System
         */
        if ( children )
                {
                XFree( children );
                }


        return( window );

}       /* -- function SearchWindowTree */



/*
 *      end of file
 */

