%module ModuleStatus
%{
#include <StatusSource/StatusSource.h>

typedef StatusSource::ModuleStatus ModuleStatus;
%}

// When we add a method that returns a python object,
// it should be returned as a python object
%typemap(python, out) PyObject* {
    $target = $source;
}

class ModuleStatus {
public:

  %addmethods {
  PyObject* getStatus(int blocking=0) {
    PyObject* res;
    StatusSource::Status status;
    if (self->getStatus(status, blocking)) {
      res = PyTuple_New(7);
      PyTuple_SET_ITEM(res, 0,
                       PyFloat_FromDouble(status.last_update.getValue()));
      PyTuple_SET_ITEM(res, 1,
                       PyFloat_FromDouble(status.last_run.getValue()));
      const char* state;
      switch (status.state) {
      case ConfigSource::NOT_RUNNING:
        state = "NotRunning";
        break;
      case ConfigSource::INITIALIZING:
        state = "Initializing";
        break;
      case ConfigSource::INITIALIZING_DISPLAY:
        state = "InitializingDisplay";
        break;
      case ConfigSource::INITIALIZED:
        state = "Initialized";
        break;
      case ConfigSource::RUNNING:
        state = "Running";
        break;
      case ConfigSource::PAUSED:
        state = "Paused";
        break;
      case ConfigSource::BLOCKED:
        state = "Blocked";
        break;
      case ConfigSource::ERROR:
        state = "Error";
        break;
      }
      PyTuple_SET_ITEM(res, 2, PyString_FromString(state));
      PyTuple_SET_ITEM(res, 3, PyFloat_FromDouble(status.status));
      PyTuple_SET_ITEM(res, 4, PyFloat_FromDouble(status.confidence));
      PyTuple_SET_ITEM(res, 5, PyFloat_FromDouble(status.avg_cycle_time));
      const char* msg = status.msg;
      if (!msg)
        msg = "";
      PyTuple_SET_ITEM(res, 6, PyString_FromString(msg));
    } else {
      res = Py_None;
      Py_INCREF(res);
    }

    return res;
  }
  }

  const char* name() const;
};
