import os
import socket
import sys
import string
import time

import ConfigSource
import SymbolTable

class Launcher:
  def __init__(self, server_host, spec=None):
    try:
      cur_host = os.environ['IPTHOST']
      self.host = cur_host
    except KeyError:
      self.host = socket.gethostname()
    self.host = socket.gethostbyname(self.host)
    self.host_name = string.join(string.split(self.host, '.'), '_')
    
    if spec is None:
      spec = 'iptclient: bool report_status=false; spec ipt_spec {unix: string module_name=%s; string host_name=%s;}' % ("Launcher"+self.host, server_host)
    self.server_host = socket.gethostbyname(server_host)
    self.symbol_table = SymbolTable.SymbolTable()
    self.server = ConfigSource.ConfigSource(spec, self.symbol_table);

  def launch(self):
    print "Starting iptshmgr"
    os.system("killall -INT iptshmgr >& /dev/null")
    os.system("killall iptshmgr run_iptshmgr iserver_set >& /dev/null")
    os.system("run_iptshmgr %s 5 >& /dev/null &" % self.server_host)
    time.sleep(2)
    
    print "Getting modules", "string Hosts.%s.modules" % self.host_name
    modules = \
            self.server.getStrings("string Hosts.%s.modules" % self.host_name)
 
    print "Launching", modules
    for m in modules:
      if m[:8] == 'iptshmgr':
        continue
      try:
        params = \
               self.server.getSubFile("struct Modules.%s" %
                                      string.join(string.split(m, '.'),
                                                  '_'))
      except RuntimeError:
        print m, "has no module information"
        continue

      is_module = int(params.get("is_module", 1))
      print m, is_module
      if not is_module:
        print "Warning, %s is not a module, not launching it" % m
        continue
      prerun = params.get("string prerun", "")
      dir = params.get("string dir", "")
      if dir and dir != '':
        if dir[0] == '$':
          parts = string.split(dir, '/')
          dir = os.environ[parts[0][1:]] + '/' + string.join(parts[1:], '/')
      command = params.get("string command", "")
      postrun = params.get("string postrun", "")
      redirect_output = params.get("string redirect_output", "/dev/null")
      interval = int(params.get("interval", 5))
      vital = int(params.get("vital", 0))
      print m, prerun,command, postrun

      if vital:
        cmd = "run_vital_module '%s' '%s' '%s' '%s' '%s' '%s' '%d' '%s' >& /dev/null" % \
              (m, self.server_host,
               prerun, command, redirect_output, postrun, interval, dir)
      else:
        cmd = "run_persistent_module '%s' '%s' '%s' '%s' '%s' '%s' '%d' '%s' >& /dev/null" % \
              (m, self.server_host,
               prerun, command, redirect_output, postrun, interval, dir)
      print cmd
      os.system('%s &' % cmd)
      

if __name__=='__main__':
  mgr = Launcher(sys.argv[1])

  mgr.launch()

  
