import _ConfigSource
import _ConfigSourcec
import ConfigFile

class ConfigSource(_ConfigSource._ConfigSource):
    def __init__(self,spec,symboltable):
        self.this = _ConfigSourcec._ConfigSource_create(spec,
                                                        symboltable.this)
        self.thisown = 1
        self.ref()

    def __del__(self):
        self.unref()

    def getSubFile(self, name):
        val = _ConfigSourcec._ConfigSource_getSubFile(self.this,name)
        return ConfigFile.ConfigFilePtr(val)

if __name__== '__main__':

    def changed(name):
        print "Changed", name
        
    st = _ConfigSource.SymbolTable();
    cs = ConfigSource('active: name=test1.cfg;', st)

    sf = cs.getSubFile('testSpec')
    s = sf.output()
    print 'Before', s
    cs.set('spec new_spec', s)
    print 'Now'
    print cs.getSubFile('new_spec').output()

    cs.set("string test_string", '"This is a test"');
    print "Test string", cs.getStrings("test_string")

    cs.parseSet('spec other_spec', s)
    print 'And now'
    print cs.getSubFile('other_spec').output()

    print cs.getString('name'), cs.getInt('val')
    cs.set('bogus', 10)
    print cs.getFloat('bogus', 12.0)

    cf = cs.getSubFile('structure')
    s = cf.output()
    print cf.output()
    print cf.test;

    print cs.getInts('tests')
    print cs.getFloats('floats')
    print cs.getStrings('strings')

    cs.set('tests', (5, 6, 7))
    print cs.getInts('tests')

    cs.notify('name', changed)
    cs.set('name', 'new name')
    cs.notify('floats', changed)
    cs.set('floats', (7, 5.2, 3.14))
    

