import sys
import time
import os
import string
from RepoMan import RepoMan

class CollectManager(RepoMan):
  def __init__(self, spec=None, display=None):
    if spec is None:
      try:
        spec = sys.argv[1]
      except:
        spec = "collect.cfg"
      spec = 'iptserver: name=%s;' % spec
    RepoMan.__init__(self, spec, display)

  def run(self):
    self.cur_time = time.strftime('%m-%d-%y.%H.%M.%S',
                                  time.localtime(time.time()))
    print "Start time", self.cur_time
    self.collect_modules = []

    RepoMan.run(self)

  def collect_run(self, collect_module):
    print "Collect run", collect_module
    self.collect_modules.append(collect_module)

  def finish(self):
    self.invoke("finish", manager=0)

    any_saving = 0
    for m in self.collect_modules:
      try:
        if len(m.crunch_files) or len(m.copy_files):
          any_saving = 1
          break
      except AttributeError:
        pass
    if not any_saving:
      return
    
    basedir=os.path.abspath(self.server.getString("string data_directory",
                                                  "."))
    data_dir_name = os.path.join(basedir, self.cur_time)    
    if os.path.exists(data_dir_name):
      print "Directory %s already exists - aborting consolidation" \
            % data_dir_name
      return
    os.mkdir(data_dir_name)
    print "Creating data directory", data_dir_name

    incoming_directory = self.server.getString("string incoming_directory",
                                               "/data")
    print "Incoming directory", incoming_directory
    for m in self.collect_modules:
      try:
        for save_name in m.crunch_files:
          path = os.path.join(incoming_directory, save_name)
          dest_name = string.join(string.split(save_name, '.')[:-1], '.') \
                      + '.rad'
          tmp_path = os.path.join(incoming_directory, dest_name)
          output_path = os.path.join(data_dir_name, dest_name)
          print "Consolidating %s to %s" % (path, output_path)
          self.sendString(m.window,
                          '\nrm -f %s\n\n\n' % tmp_path)
          self.sendString(m.window,
                          '\ncdcrunch %s %s\n\n\n' % (path, tmp_path))
          self.do_move(m, tmp_path, output_path)
        for save_name in m.copy_files:
          path = os.path.join(incoming_directory, save_name)
          dest_name = save_name
          output_path = os.path.join(data_dir_name, dest_name)
          print "Copying %s to %s" % (path, output_path)
          self.do_copy(m, path, output_path)
      except AttributeError:
        pass

  def do_copy(self, m, path, output_path):
    self.sendString(m.window,
                    '\ncp -a %s %s\n\n' % (path, output_path))

  def do_move(self, m, path, output_path):
    self.sendString(m.window,
                    '\nmv %s %s\n\n' % (path, output_path))
    

if __name__=='__main__':
  mgr = CollectManager()

  mgr.initialize()
  mgr.startup()
  mgr.serve()




