///////////////////////////////////////////////////////////////////////////////
//
//                               PyUnpackAction.h
//
// Implements an action which unpacks data from a python object
//
// Classes defined for export:
//     PyUnpackAction
//     
///////////////////////////////////////////////////////////////////////////////

#ifndef utils__py_unpack_action_h
#define utils_py_unpack_action_h

#include <utils/formatting/DataAction.h>

struct _object;
typedef _object PyObject;

class PyUnpackAction : public utils::DataAction {
    UTILS_BASE_HEADER(PyUnpackAction);
  public:
    PyUnpackAction(PyObject* src = NULL, void* data=NULL);
    virtual ~PyUnpackAction();

    PyObject* getObject() const { return _object; }
    void setObject(PyObject*);
    
    virtual bool actInt();
    virtual bool actShort();
    virtual bool actLong();
    virtual bool actFloat();
    virtual bool actDouble();
    virtual bool actChar();
    virtual bool actLength(int size);

    virtual bool actString();
    virtual bool actPtr(utils::FormatSpec*);

    virtual bool actFixedArray(const utils::Vector<int>& sizes,
                               utils::FormatSpec* fmt);
    virtual bool actVarArray(utils::StructSpec*,
                             const utils::Vector<int>&, utils::FormatSpec*);

    virtual bool actStruct(int size, utils::FormatSpec** elems);

    void fromData(void* src, int size) {
        bcopy(src, curData(), size);
        addSize(size);
    }

    static bool unpack(utils::FormatSpec*, PyObject* obj, void*);
    static void* unpack(utils::FormatSpec*, PyObject* obj);
    static void initClass();

  private:
    bool unpackLong(long& l);
    bool unpackDouble(double &d);

  private:
    PyObject* _object;  // object to unpack from
};

extern void initPyFormatting(utils::FormatParser&);

#endif
