///////////////////////////////////////////////////////////////////////////////
//
//                            PyTimerHandler.h
//
// Defines a timer handler subclass which will invoke a python method
// when executed
//
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_py_timer_handler
#define utils_py_timer_handler

#include <ipt/callbacks.h>

struct _object;
typedef _object PyObject;

class PyTimerHandler : public IPTimerCallback {
  public:
    PyTimerHandler(PyObject* method); 
    virtual ~PyTimerHandler();

    virtual void Execute(IPTimer*);

    void setMethod(PyObject* method);

  private:
    PyObject* _method;   // the python method to invoke
};

#endif

