#include "PyMessageHandler.h"
#include "PyConnectHandler.h"
#include "PyTimerHandler.h"

#include <Python.h>

extern "C" void SWIG_MakePtr(char *, void *, char *);

PyMessageHandler::PyMessageHandler(PyObject* method)
{
    _method=NULL;
    setMethod(method);
}

PyMessageHandler::~PyMessageHandler()
{
    Py_XDECREF(_method);
}

void PyMessageHandler::Execute(IPMessage* msg)
{
    if (!_method)
        return;
    PyObject* result;

    // Build argument list
    char msg_temp[128];
    SWIG_MakePtr(msg_temp, (char*) msg, "_Message_p");
    if (PyCallable_Check(_method)) {
        PyObject* arglist = Py_BuildValue("(s)", msg_temp);
        result = PyObject_CallObject(_method, arglist);
        Py_DECREF(arglist);
    } else
        result = PyObject_CallMethod(_method, "execute", "(s)", msg_temp);
    if (!result) {
        printf("Problem with executing message handler:  ");
        PyErr_Print();
    } else
        Py_DECREF(result);
}

void PyMessageHandler::setMethod(PyObject* method)
{
    if (method == _method)
        return;
    Py_XDECREF(_method);
    _method = method;
    Py_XINCREF(_method);
}

PyConnectHandler::PyConnectHandler(PyObject* method)
{
    _method=NULL;
    setMethod(method);
}

PyConnectHandler::~PyConnectHandler()
{
    Py_XDECREF(_method);
}

void PyConnectHandler::Execute(IPConnection* msg)
{
    if (!_method)
        return;
    PyObject* result;

    // Build argument list
    char msg_temp[128];
    SWIG_MakePtr(msg_temp, (char*) msg, "_Connection_p");
    if (PyCallable_Check(_method)) {
        PyObject* arglist = Py_BuildValue("(s)", msg_temp);
        result = PyObject_CallObject(_method, arglist);
        Py_DECREF(arglist);
    } else
        result = PyObject_CallMethod(_method, "execute", "(s)", msg_temp);
    if (!result) {
        PyErr_Print();
    } else
        Py_DECREF(result);
}

void PyConnectHandler::setMethod(PyObject* method)
{
    if (method == _method)
        return;
    Py_XDECREF(_method);
    _method = method;
    Py_XINCREF(_method);
}

PyTimerHandler::PyTimerHandler(PyObject* method)
{
    _method=NULL;
    setMethod(method);
}

PyTimerHandler::~PyTimerHandler()
{
    Py_XDECREF(_method);
}

void PyTimerHandler::Execute(IPTimer* msg)
{
    if (!_method)
        return;
    PyObject* result;

    // Build argument list
    char msg_temp[128];
    SWIG_MakePtr(msg_temp, (char*) msg, "_Timer_p");
    if (PyCallable_Check(_method)) {
        PyObject* arglist = Py_BuildValue("(s)", msg_temp);
        result = PyObject_CallObject(_method, arglist);
        Py_DECREF(arglist);
    } else
        result = PyObject_CallMethod(_method, "execute", "(s)", msg_temp);
    if (!result) {
        PyErr_Print();
    } else
        Py_DECREF(result);
}

void PyTimerHandler::setMethod(PyObject* method)
{
    if (method == _method)
        return;
    Py_XDECREF(_method);
    _method = method;
    Py_XINCREF(_method);
}

