import string
from _ConfigFile import *
import _ConfigFile
import _ConfigFilec

class ConfigFile(_ConfigFile._ConfigFile):
    def __init__(self,*args) :
        self.this = apply(_ConfigFilec.new__ConfigFile,()+args)
        self.thisown = 1
        self.attachments = {}

    def __getattr__(self, name):
        try:
            return self.__dict__[name]
        except KeyError:
            return self.get(name, None)

    def attach(self, name, method):
        self.attachments[name] = method

    def detach(self, name):
        try:
            del self.attachments[name];
        except KeyError:
            pass

    def check_attachments(self, name, val):
        tag = string.split(name)[-1]
        try:
            self.attachments[tag](val)
        except KeyError:
            pass

    def set(self, name, val, ignore_duplicates=1):
        self.check_attachments(name, val)
        return _ConfigFile._ConfigFile.set(self, name, val, ignore_duplicates)

    def parseSet(self, name, value, ignore_duplicates=1):
        self.check_attachments(name, value)
        return _ConfigFile._ConfigFile.parseSet(self, name, value,
                                                ignore_duplicates)

    def getFile(self, name):
        elem = self.lookup(name);
        return ConfigFile(elem)

    def setFile(self, name, file):
        self.parse(name + file.output())

if __name__ == '__main__':
    def test(val):
        print "Setting name to", val
        
    cf = ConfigFile()
    cf.open('test1.cfg')
    print cf.name, cf.val
    print cf.bogus

    cf.attach("name", test)
    cf.set("name", "Other name")
    print "Now", cf.name


