#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <utils/SymbolTable.h>

#include <ConfigSource/ConfigSource.h>

int main(int argc, char** argv)
{
  if (argc < 4)
    return -1;

  utils::SymbolTable* globals = new utils::SymbolTable;
  utils::String name = "IServerSet";
  name += utils::String(getpid());

  globals->set("ModuleName", name.getString());

  char buffer[500];
  snprintf(buffer, 500,
           "iptclient: report_status = false; spec ipt_spec {unix: module_name=%s; host_name=%s;}",
           name.getString(), argv[1]);
  ConfigSource* config_src = ConfigSource::create(buffer, globals);
  if (!config_src) {
    printf("Invalid config source '%s'\n", buffer);
    exit(-1);
  }

  printf("Setting '%s' = '%s'\n", argv[2], argv[3]);
  if (config_src->set(argv[2], argv[3])) {
    printf("Success!\n");
  } else
    printf("Failure!\n");

  delete globals;
}
