/* $Revision: 1.1 $

$Date: 2004/04/26 19:58:43 $

$Author: jayg $*/
/** @file test_texture.cc

PROJECT: Grand Challenge
AUTHOR: Chris Urmson (curmson@ri.cmu.edu)
DESCRIPTION:

*/
/*REVISION HISTORY

$Log: test_texture.cc,v $
Revision 1.1  2004/04/26 19:58:43  jayg
First version of GLUtils ripped from Redteam

Revision 1.1  2003/11/17 05:19:37  curmson
Added a number of objects for rendering texture mapped stuff.


(c) Copyright 2003 CMU. All rights reserved.
*/
#ifndef TEST_TEXTURE_CC
#define TEST_TEXTURE_CC
#include <GLUtils/glut_window.h>
#include <GLUtils/GL_TextureMap.h>
#include <Common/PGMImage.h>
#include <iostream>
using namespace std;

int main(int argc, char *argv[]) {

  if (argc!=2) {
    cout << "usage: test_texture PGMIMAGEFILE" << endl;
  }

  PGMImage src;
  src.readRGBImage(argv[1]);
  Glut_Window win("texture map",500,500);
  win.set_z_up();
  GL_Origin gl_ori(10);
  GL_TextureMap gl_map;
  gl_map.render(src.getWidth(),src.getHeight(),src.getImage(),
		r3Vector(0,0),20,20);
  win.register_object(&gl_map);
  win.register_object(&gl_ori);
  win.run();


}


#endif //ifndef TEST_TEXTURE_CC
