/* -*-c++-*-
=========================================================================
=                                                                       =
=                                TEST_GL_UTILS.CC                                                                       =
=                                                                       =
=========================================================================

A test program to show how to use the basic classes 

Target: VxWorks/UNIX/Generic

Designed by:    Chris Urmson
Written by:     Chris Urmson
Date:           June 2002

Copyright 2002 Carnegie Mellon University
$Author: jayg $
$Date: 2004/04/26 19:58:43 $
$Header: /IUS/jeep/cvsroot/ModUtils/GLUtils/test_gl_utils.cc,v 1.1 2004/04/26 19:58:43 jayg Exp $
$Id: test_gl_utils.cc,v 1.1 2004/04/26 19:58:43 jayg Exp $
$Log: test_gl_utils.cc,v $
Revision 1.1  2004/04/26 19:58:43  jayg
First version of GLUtils ripped from Redteam

Revision 1.1  2003/09/06 22:25:04  curmson
First commit of gl utils in this working directory structure.

Revision 1.1  2003/02/25 14:18:39  curmson
First commit of the new gl_utils library.  This code is somewhat cleaner than the old glHelpers code and is more powerful.

It supports new features including:
        multiple windows
        lighting
        object registration
        ability to set z up or z down orientation

Revision 1.4  2002/09/17 13:45:17  curmson
Added the ability to register objects for drawing, thus elliminating the need to subclass glut window in some cases.

Revision 1.3  2002/07/24 18:40:27  curmson
Modified openGL camera positioning routines to render with the correct coordinate system orientations (i.e. X forward, Y to the right, Z down).

Revision 1.2  2002/07/01 21:59:26  curmson
Added more comments and restructured initialization to avoid some warning messages on certain systems.

Revision 1.1  2002/06/26 01:01:32  curmson
This is a first commit of the util_open_gl module.  It provides a simplified interface to glut and the openGL, and simplifies the task of creating a quick debugging UI.



 ------------------------------------------------------------------------*/
#include "glut_window.h"
#include "gl_object.h"
#include <stdio.h>

class Shifting_Window: public Glut_Window {
  GL_Origin go;
  GL_Ground_Plane gp;
  int i;
public:
  Shifting_Window(void): Glut_Window("Shifting_Window",300,300), go(5),
                         gp(1,20,0.5,0,0) {
    position_window(200,200);
    i=0;
    register_timer(1000,15);
    post_redisplay();
    register_object(&go);
    register_object(&gp);
  }; 

  // draw contents of the window, including a translucent triangle
  void draw(void) {
    glColor4f(0,0,0.5,0.5);
    glBegin(GL_TRIANGLES); {
      glVertex3f(5,5,0);
      glVertex3f(2.5,2.5,-1.5);
      glVertex3f(0,2.5,-5);
    }glEnd();
    
    draw_text("the triangle should be translucent",0.125,0.125);
  };


  // provide a timer function that shifts the window every second
  void timer_func(unsigned char timer_ID) {
    position_window(200+i*10,200);
    register_timer(1000,15);
    i++;
    post_redisplay();
  };
  
};


class Spinning_Window: public Glut_Window {
  GL_Origin go;
  GL_Ground_Plane gp;
public:
  Spinning_Window(void): Glut_Window("Spinning_Window",300,300), go(3),
                         gp(1,20,0.0,0.0,0.5) {
    position_window(200,700);
    register_timer(100,1);
    register_object(&gp);
    register_object(&go);
  };
/*  void draw(void) {
    char buffer[100];
    go.draw();
    gp.draw();
    };*/
  
  //overload the timer functino to spin the viewpoint every 10th of a second
  void timer_func(unsigned char timer_ID) {
    view_azimuth+=5;
    register_timer(100,1);
    post_redisplay();
  };
  
};




int main(void) {
  // create the two windows
  cout << "you should see one window shifting along your screen, and one window with a spinning origin & mesh\n";
  Shifting_Window sw;
  Spinning_Window sp;
  // calling run on one of them, starts both running
  sp.run();
}



