/* $Revision: 1.1 $

$Date: 2004/07/24 17:55:44 $

$Author: jayg $*/
/** @file GL_VectorField.cc

PROJECT: Grand Challenge
AUTHOR: Chris Urmson (curmson@ri.cmu.edu)
DESCRIPTION:

*/
/*REVISION HISTORY

$Log: GL_VectorField.h,v $
Revision 1.1  2004/07/24 17:55:44  jayg
Went back to Red Team makefile, added vector field header

Revision 1.4  2004/02/18 09:26:30  kp
include a direction to draw vectors in

Revision 1.3  2004/02/14 07:04:13  curmson
Fixed bugs in circle fitter so that it now works with non-full vectors.
Tweaked Vectorfield so that display is better.

Revision 1.2  2004/02/13 01:59:18  curmson
Changes to fixe vector field and circle fitter to work with arbitrary point types.

Revision 1.1  2004/02/12 16:49:49  mkj
Forggoten file


(c) Copyright 2004 CMU. All rights reserved.
*/
#ifndef GL_VECTORFIELD_CC
#define GL_VECTORFIELD_CC

#include <GLUtils/gl_object.h>
#include <vector>
using namespace std;


template <class Point_Type> 
class GL_VectorFieldBase: public GL_Display_List_Object {
public: 
  GL_VectorFieldBase(void) {};
  
  void render_field(vector<Point_Type> &pts, vector<r3Vector> &vecs,
                    float r, float g, float b) {
    unsigned int i;
    start_list(); {
      glColor3f(r,g,b);
      glBegin(GL_LINES); {
	for (i=0;i< pts.size();i++) {
	  glVertex3f(pts[i][0],pts[i][1],pts[i][2]);
	  glVertex3f(pts[i][0]+vecs[i][0],pts[i][1]+vecs[i][1],
		     pts[i][2]+vecs[i][2]);
	}
      } glEnd();
    } end_list(); 
  };

  void render_field(vector<Point_Type> &pts, vector<double> &heights,
                    float r, float g, float b, 
		    float dirX=0, float dirY=0, float dirZ=1,
		    float thickness =1) {
    unsigned int i;
    start_list(); {
      glColor3f(r,g,b);
      glLineWidth(thickness);
      glPointSize(thickness);
      for (i=0;i< pts.size();i++) {
        if (heights[i]>0.00001) {
          glBegin(GL_LINES); {
            glVertex3f(pts[i][0],pts[i][1],pts[i][2]);
            glVertex3f(pts[i][0]+heights[i]*dirX,
		       pts[i][1]+heights[i]*dirY,
                       pts[i][2]-heights[i]*dirZ); // minus heights for -ve z
          } glEnd();
        } else {
          glBegin(GL_POINTS); {
            glVertex3f(pts[i][0],pts[i][1],pts[i][2]);
          } glEnd();
        }
      }
      glLineWidth(1.0);
      glPointSize(1.0);
    } end_list(); 
  };

};

typedef GL_VectorFieldBase<r3Vector> GL_VectorField;

#endif //ifndef GL_VECTORFIELD_CC
