/* $Revision: 1.1 $

$Date: 2004/04/26 19:58:42 $

$Author: jayg $*/
/** @file GL_TextureMap.h

PROJECT: Grand Challenge
AUTHOR: Chris Urmson (curmson@ri.cmu.edu)
DESCRIPTION: This file contains a class to draw a texture to a rectangle in the an X-Y plane.

*/
/*REVISION HISTORY

$Log: GL_TextureMap.h,v $
Revision 1.1  2004/04/26 19:58:42  jayg
First version of GLUtils ripped from Redteam

Revision 1.1  2003/11/17 05:19:36  curmson
Added a number of objects for rendering texture mapped stuff.


(c) Copyright 2003 CMU. All rights reserved.
*/
#ifndef GL_TEXTUREMAP_H
#define GL_TEXTUREMAP_H
#include <GLUtils/gl_object.h>
// this is the maximum dimension of a texture we will create
#define MAX_TEXTURE_DIM 2048

class GL_TextureMap: public GL_Display_List_Object {
public:
  GL_TextureMap(void);
  virtual ~GL_TextureMap(void);
  /**
     This will render to an X-Y plane in world space the pixmap (packed RGB format) passed in data.
     The image is pixWidth by pixLength pixels in size.  data[0] is the
     Red byte of the top left corner of the image.
     
     topLeft is the location in world space where the top left corner of the image should be drawn.  width and length are the size of the image in world space units.

     returns true if the texture could be rendered, false otherwise
*/

  bool render(int pixWidth, int pixLength, unsigned char * data,
              r3Vector topLeft, double width, double length);

protected:
  unsigned char *_img; // this holds the texture we're going to render
  int _texId; // the GL texture ID for our texture

  // this copies the passed texture into our texture buffer and updates openGL
  bool copyTexture(int pixWidth, int pixLength, unsigned char *data);


};


#endif //ifndef GL_TEXTUREMAP_H
