/* $Revision: 1.1 $

$Date: 2004/04/26 19:58:42 $

$Author: jayg $*/
/** @file GL_Quadrangle.h

PROJECT: Grand Challenge
AUTHOR: Chris Urmson (curmson@ri.cmu.edu)
DESCRIPTION: Code to draw a quadrangle.

*/
/*REVISION HISTORY

$Log: GL_Quadrangle.h,v $
Revision 1.1  2004/04/26 19:58:42  jayg
First version of GLUtils ripped from Redteam

Revision 1.1  2003/11/11 08:13:33  curmson
Added code for some gl_object primitive types.


(c) Copyright 2003 CMU. All rights reserved.
*/
#ifndef GL_QUADRANGLE_H
#define GL_QUADRANGLE_H
#include <GLUtils/gl_object.h>

/* This is a class that renders a quadrangle region*/
class GL_Quadrangle: public GL_Display_List_Object {
protected:
  float _r, _g, _b;
  // this routine generates a display list of the described quadrangle
  void genDisplayList(r3Vector vert[4]) {
    start_list(); {
      glPushMatrix(); {
	
	glColor3f(_r,_g,_b);
	glBegin(GL_QUADS);
	
	glTexCoord2f(0.0, 0.0); 
	glVertex3f(vert[0].x, vert[0].y, vert[0].z);
   
	glTexCoord2f(0.0, 1.0); 
	glVertex3f(vert[1].x, vert[1].y, vert[2].z);

	glTexCoord2f(1.0, 1.0); 
	glVertex3f(vert[2].x, vert[2].y, vert[2].z);

	glTexCoord2f(1.0, 0.0); 
	glVertex3f(vert[3].x, vert[3].y, vert[3].z);
	glEnd();
      } glPopMatrix();

    } end_list();
  };

public:
  GL_Quadrangle(r3Vector vert[4], 
                float r, float g, float b) {
    _r = r; _g = g; _b =b;
    genDisplayList(vert);
  };

  void setVerticies(r3Vector vert[4]) {
    genDisplayList(vert);
  };
};


#endif //ifndef GL_QUADRANGLE_H


