/* $Revision: 1.1 $

$Date: 2004/04/26 19:58:42 $

$Author: jayg $*/
/** @file GL_Lozenge.h

PROJECT: Grand Challenge
AUTHOR: Chris Urmson (curmson@ri.cmu.edu)
DESCRIPTION:  A class to draw a losenge shaped area- something with two half discs at each end and a rectangle between them...  Might be used to draw a course segment.

*/
/*REVISION HISTORY

$Log: GL_Lozenge.h,v $
Revision 1.1  2004/04/26 19:58:42  jayg
First version of GLUtils ripped from Redteam

Revision 1.1  2003/11/28 05:51:14  curmson
Added code to draw lozenges (i.e. waypoint corridors) and added a couple of macros to simplify using r3Vector with GL code.


(c) Copyright 2003 CMU. All rights reserved.
*/
#ifndef GL_LOZENGE_H
#define GL_LOZENGE_H
#include <GLUtils/gl_object.h>

class GL_Lozenge: public GL_Display_List_Object {
  float _r,_g, _bl, _alpha;
  bool _fill;
public:
  /**
     This creates a 0 area lozenge, but sets up the colors to be used.  If fill is set 
     true,the region will be painted, otherwise,it will just the boundaries will be 
     rendered*/
  GL_Lozenge( float r, float g, float bl,bool fill=true, float alpha=1.0) {
    _r = r; _g = g; _bl = bl; _alpha= alpha; _fill = fill;
    renderLozenge(r3Vector(), r3Vector(),0);
  }

  /**
     this creates a lozenge with circular end points centered at a and b, with 
     a radius of radius of radius and with color r,g,bl,alpha.  If fill is set true,
     the region will be painted, otherwise,it will just the boundaries will be rendered
  */
  GL_Lozenge(r3Vector a, r3Vector b, double radius,
	     float r, float g, float bl, bool fill = true,float alpha=1.0) {
    _r =r; _g= g; _bl=bl;_alpha = alpha; _fill =fill;
    renderLozenge(a,b,radius);
  }

  void renderLozenge(r3Vector a, r3Vector b, double radius);

};

#endif //ifndef GL_LOZENGE_H
