/* $Revision: 1.1 $

$Date: 2004/04/26 19:58:42 $

$Author: jayg $*/
/** @file GL_Annulus.h

PROJECT: Grand Challenge
AUTHOR: Chris Urmson (curmson@ri.cmu.edu)
DESCRIPTION:  Code to draw an annulus

*/
/*REVISION HISTORY

$Log: GL_HeightMap.h,v $
Revision 1.1  2004/04/26 19:58:42  jayg
First version of GLUtils ripped from Redteam

Revision 1.4  2003/11/30 18:59:22  mkj
heightmap now niffty

Revision 1.3  2003/11/30 18:03:22  mkj
colors added heightmap

Revision 1.2  2003/11/14 03:03:43  mkj
lighting changes

Revision 1.1  2003/11/14 02:16:19  mkj
 added heightmap display

Revision 1.1  2003/11/11 08:13:32  curmson
Added code for some gl_object primitive types.


(c) Copyright 2003 CMU. All rights reserved.
*/
#ifndef GL_HEIGHTMAP_H
#define GL_HEIGHTMAP_H
#include <GLUtils/gl_object.h>
#include <Common/r3Vector.h>

class GL_Heightmap: public GL_Display_List_Object {
public:
  float originX, originY;
  float dX, dY;
  int numX, numY;
  MapFloatData *heights;
  float red, green, blue,alpha;

  /** 
      x,y,z define the location of the heightmap
      rOut and rIn are the inner and outer radii of the heightmap
      r,g,b define the color of the heightmap*/
   GL_Heightmap(MapFloatData *heights,
           int numX, int numY,
                  float dX, float dY,
		float OX, float OY,float red=0.0,float green=1.0,float blue=0.0,float alpha=1.0){
  originX = OX;
  originY = OY;
  this->dX = dX;
  this->dY = dY;
  this->numX = numX;
  this->numY = numY;
  this->heights = heights;
  

  this->red=red;
  this->green=green;
  this->blue=blue;
  this->alpha=alpha;
createHeightMap();
   }

  void insertHeightMap(MapFloatData *heights){
 this->heights = heights;
 createHeightMap();
  }
  void createHeightMap(void) {
    int r,c;
    float x,y;
    double redscaled;
    double min=10000000.0;
    double max=-10000000.0;
    double range=0.0;
     for (r=0, y=originY;r<numY-1;r++,y+=dY) 

       for (c = 0, x=originX;c<numX-1;c++,x+=dX) {
	  double height = *heights->mapIndex(c,r);
	  if(height > max)
	    max=height;
	  if(height < min)
	    min=height;
       }
     range=max-min;

      start_list(); {
	glPushMatrix();
	glTranslatef(-numX/2.0, -numY/2.0,0.0);

	  for (r=0, y=originY;r<numY-1;r++,y+=dY) {
	glBegin(GL_TRIANGLE_STRIP); {
        for (c = 0, x=originX;c<numX-1;c++,x+=dX) {
	  double height = *heights->mapIndex(c,r);
	  redscaled = (height - min)/range; 
	 
	  glColor4f(0.7,1.0-redscaled,1.0-redscaled,alpha);
	  setNormal(r,c);
          glVertex3f(x,y,*heights->mapIndex(c,r));
	   setNormal(r+1,c);
          glVertex3f(x,y+dY,*heights->mapIndex(c,(r+1)));
        }
	}; glEnd();
      }
    };
      
      glPopMatrix();
      end_list();
}

void setNormal(int r, int c) {
  r3Vector v0, v1 ,v2;
  r3Vector e0, e1;
  r3Vector n;
  calculateVertex(r,c,v0);
  calculateVertex(r,c+1,v1);
  calculateVertex(r+1,c,v2);
  e0=v1-v0;
  e1=v2-v0;
  n=e0*e1;
  n.normalize();
  glNormal3f(n.x,n.y,n.z);
}

void calculateVertex(int r, int c, r3Vector v) {
  v[0] = originX + c*dX;
  v[1] = originY + r*dY;
  v[2] = *heights->mapIndex(c,r);
                                                                              
}


};

#endif //ifndef GL_HEIGHTMAP_H
