/* $Revision: 1.1 $

$Date: 2004/04/26 19:58:42 $

$Author: jayg $*/
/** @file GL_Cylinder.h

PROJECT: Grand Challenge
AUTHOR: Chris Urmson (curmson@ri.cmu.edu)
DESCRIPTION:  Defines a class tognerate an open ended cylinder

*/
/*REVISION HISTORY

$Log: GL_Cylinder.h,v $
Revision 1.1  2004/04/26 19:58:42  jayg
First version of GLUtils ripped from Redteam

Revision 1.1  2003/11/11 08:13:33  curmson
Added code for some gl_object primitive types.


(c) Copyright 2003 CMU. All rights reserved.
*/
#ifndef GL_CYLINDER_H
#define GL_CYLINDER_H
#include <GLUtils/gl_object.h>

class GL_Cylinder: public GL_Display_List_Object {
public:
  /*
    The cylinder is oriented in the Z direction, centered around the origin.
    rad and h define radius and height respectively
    r,g,b,a define the color (with an alpha channel*/
  GL_Cylinder(float rad, float h, float r,float g, float b, float a) {
    start_list(); {
      glColor4f(r,g,b,a);
      GLUquadricObj *obj = gluNewQuadric();
      gluQuadricDrawStyle(obj,GLU_FILL);
      gluQuadricNormals(obj, GLU_SMOOTH);
      gluQuadricOrientation(obj, GLU_OUTSIDE);
      gluCylinder(obj,rad,rad,h,10,1);
      gluDeleteQuadric(obj);
    } end_list();
  }
};



#endif //ifndef GL_CYLINDER_H
