/* $Revision: 1.1 $

$Date: 2004/04/26 19:58:42 $

$Author: jayg $*/
/** @file GL_Box.h

PROJECT: Grand Challenge
AUTHOR: Chris Urmson (curmson@ri.cmu.edu)
DESCRIPTION:  Defines a class tognerate an open ended box

*/
/*REVISION HISTORY

$Log: GL_Box.h,v $
Revision 1.1  2004/04/26 19:58:42  jayg
First version of GLUtils ripped from Redteam

Revision 1.1  2004/01/18 18:43:24  kp

it's a box!

Revision 1.1  2003/11/11 08:13:33  curmson
Added code for some gl_object primitive types.


(c) Copyright 2003 CMU. All rights reserved.
*/
#ifndef GL_BOX_H
#define GL_BOX_H
#include <GLUtils/gl_object.h>

class GL_Box: public GL_Display_List_Object {
public:
  /*
    The box is oriented in the Z direction, centered around the origin.
    size defines the size of the box
    r,g,b,a define the color (with an alpha channel)
  */
  GL_Box(float size, float r,float g, float b, float a) {
    start_list(); {
      glColor4f(r,g,b,a);
      glutSolidCube(size);
    } end_list();
  }
};



#endif //ifndef GL_BOX_H
