/* $Revision: 1.1 $

$Date: 2004/04/26 19:58:42 $

$Author: jayg $*/
/** @file GL_Annulus.h

PROJECT: Grand Challenge
AUTHOR: Chris Urmson (curmson@ri.cmu.edu)
DESCRIPTION:  Code to draw an annulus

*/
/*REVISION HISTORY

$Log: GL_Annulus.h,v $
Revision 1.1  2004/04/26 19:58:42  jayg
First version of GLUtils ripped from Redteam

Revision 1.1  2003/11/11 08:13:32  curmson
Added code for some gl_object primitive types.


(c) Copyright 2003 CMU. All rights reserved.
*/
#ifndef GL_ANNULUS_H
#define GL_ANNULUS_H
#include <GLUtils/gl_object.h>


class GL_Annulus: public GL_Display_List_Object {
public:
  /** 
      x,y,z define the location of the annulus
      rOut and rIn are the inner and outer radii of the annulus
      r,g,b define the color of the annulus*/
  GL_Annulus(float x, float y, float z, 
	     float rOut, float rIn,
	     float r, float g, float b) {
    start_list(); {
      GLUquadricObj *obj = gluNewQuadric();
      glPushMatrix(); {
	
	glTranslatef(x,y,z-0.05);
	glColor3f(r,g,b);
	gluQuadricDrawStyle(obj, GLU_FILL);
	gluQuadricNormals(obj, GLU_SMOOTH);
	gluQuadricOrientation(obj, GLU_OUTSIDE);
	gluDisk(obj,rIn,rOut,10,2);
      } glPopMatrix();
      gluDeleteQuadric(obj);
    } end_list();
  };

  

};

#endif //ifndef GL_ANNULUS_H
