#ifndef DISPLAY_WINDOW_H
#define DISPLAY_WINDOW_H

/*
 * Stuff needed whether or not we're stubbing out the display code
 */
enum DisplayCoordFrame {
        DISPLAY_GLOBAL,  /* Use global coordinates */
        DISPLAY_SMOOTH,  /* Use smooth global coordinates */
        DISPLAY_VEHICLE, /* Use vehicle-relative coordinates */
        DISPLAY_WINDOW   /* Use screen coordinates */
};

/*
 * Folks shouldn't be including opengl headers directly, catch and chide them
 * if they included them before this point
 */
#if defined (GL_VERSION_1_1) || defined (__gl_h)
#error "You seem to have included <GL/gl.h> directly.  Don't do that; just include Display/Display.h"
#endif


#ifdef DISABLE_DISPLAY
#include "FakeGL.h"
#include "FakeDisplay.h"
#else
#include <GL/gl.h>
#include "RealDisplay.h"
#endif

#endif

                
