#ifndef __SX12__
#define __SX12__

/* Video system constants               */
#define NTSC    2
#define PAL	1

/* Video input type constants           */
#define CVIDEO  0    /* Composite video */
#define SVIDEO  1    /* S-Video         */


/*****************************************************************************/
/* The ioctl() commands. See ioctl(2) man pages                              */
/*                                                                           */
/* Examples:                                                                 */
/*                                                                           */
/*    ioctl(handle, X12_IOC_SET_INPUT, 5);                                   */
/*    ioctl(handle, X12_IOC_RESET);                                          */
/*    count = ioctl(handle, X12_IOC_GET_FRAMECOUNT);                         */
/*    etc...                                                                 */
/*****************************************************************************/
#define X12_IOC_RESET                 1 /* Resets the 512                    */

#define X12_IOC_SET_INPUT             2 /* Select video input, i.e. 0-4      */

#define X12_IOC_SET_INPUT_TYPE        3 /* Sets video input type, i.e.       */
                                        /* SVIDEO (1) or CVIDEO (0)          */

#define X12_IOC_SET_SYSTEM            4 /* Set video system, i.e. NTSC (2)   */
                                        /* or PAL (1)                        */

#define X12_IOC_SET_BITRATE           5 /* Set desired bit rate, typically   */
                                        /* 700,000 to 10,000,000             */

#define X12_IOC_SET_PICSIZE           6 /* Set picture size and compression  */
                                        /* system: D1 MPEG-2 (0),            */
                                        /*     1/2 D1 MPEG-2 (1),            */
                                        /*     2/3 D1 MPEG-2 (2),            */
                                        /*     or CIF MPEG-1 (3)             */

#define X12_IOC_SET_M                 7 /* Sets number of frames in Group    */
                                        /* of Pictures                       */

#define X12_IOC_SET_N                 8 /* Sets distance between I/P frames  */

#define X12_IOC_SET_VBR               9 /* Enables (1)/disables (0)          */
                                        /* variable bit rate compression     */

#define X12_IOC_GET_FRAMECOUNT        10/* Returns compression frame count   */

#define X12_IOC_GET_DISPLAYFRAMECOUNT 11/* Returns decompression frame count */

#define X12_IOC_GET_DROPPEDFRAMES     12/* Returns number of dropped frames  */
                                        /* during compression                */

#define X12_IOC_GET_VQSIZE            13/* Returns amount of data in video   */
                                        /* queue                             */

#define X12_IOC_WRITE_GPIO            14/* Sets state of GPIO pins           */

#define X12_IOC_READ_GPIO             15/* Reads state of GPIO pins          */

#define X12_IOC_SET_REDUCED_FRAME_RATE 16/* Reduces the frame rate to non-   */
                                        /* standard MPEG values.             */
                                        /* bits 0-7  -- number of frames on  */
                                        /* bits 8-15 -- number of frames off */
                                        /* E.g. a value of 0x0101 would give */
                                        /* a frame rate of 15 for NTSC.      */
                                        /* E.g. a value of 0x0102 would give */
                                        /* a frame rate of 20 for NTSC.      */

/* !!!! THE FOLLOWING CAN ONLY BE USED WITH THE SENSORAY 301 CPU BOARD !!!   */
#define X12_IOC_SET_HEADER_MODE       17/* 1- enables header mode            */

/*****************************************************************************/


#endif /* __SX12__ */
