(load-option 'hash-table)

(if (let ((package (name->package '(RUNTIME OBJECT-SYSTEM))))
      (or (not package)
	  (not (access sos-loaded? (package/environment package)))))
    (let ((merge-pathname
	   (let ((pathname
		  (let ((environment
			 (package/environment (find-package '(RUNTIME LOAD))))
			(name 'LOAD/CURRENT-PATHNAME))
		    (and (not (lexical-unassigned? environment name))
			 (lexical-reference environment name)))))
	     (if pathname
		 (let ((directory (directory-pathname pathname)))
		   (lambda (pathname)
		     (merge-pathnames pathname directory)))
		 (lambda (pathname)
		   pathname)))))
      (if (not (name->package '(RUNTIME OBJECT-SYSTEM)))
	  (let ((exported-names (read-file (merge-pathname "exports.scm"))))
	    (let ((global (package/environment (find-package '()))))
	      (let ((sos
		     (eval `(LET ,(map (lambda (name) `(,name))
				       exported-names)
			      (THE-ENVIRONMENT))
			   global)))
		(for-each (lambda (name)
			    (environment-link-name global sos name))
			  exported-names)
		(local-assignment sos 'SOS-LOADED? #f)
		(environment-link-name sos '(RUNTIME RECORD) 'RECORD-TYPE-TYPE)
		(package/add-child! (find-package '(RUNTIME))
				    'OBJECT-SYSTEM
				    sos)))))
      (let ((environment 
	     (package/environment (find-package '(RUNTIME OBJECT-SYSTEM))))
	    (syntax-table syntax-table/system-internal))
	(load (merge-pathname "wrapper") environment syntax-table #t)
	(load (merge-pathname "cache") environment syntax-table #t)
	(load (merge-pathname "sos") environment syntax-table #t)
	(load (merge-pathname "macros") environment syntax-table #t)
	(syntax-table/define system-global-syntax-table 'DEFINE-CLASS
	  (lexical-reference environment 'TRANSFORM:DEFINE-CLASS))
	(syntax-table/define system-global-syntax-table
			     'DEFINE-GENERIC-PROCEDURE
	  (lexical-reference environment 'TRANSFORM:DEFINE-GENERIC-PROCEDURE))
	(syntax-table/define system-global-syntax-table 'DEFINE-METHOD
	  (lexical-reference environment 'TRANSFORM:DEFINE-METHOD))
	(syntax-table/define system-global-syntax-table 'METHOD
	  (lexical-reference environment 'TRANSFORM:METHOD))
	(local-assignment environment 'SOS-LOADED? #t))
      (gc-flip)
      unspecific))