;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                 ;;;
;;;                     S c o o p s                                 ;;;
;;;                                                                 ;;;
;;;                                                                 ;;;
;;;		Rewritten 5/20/87 for cscheme			    ;;;
;;;		by Steve Sherin--U of P				    ;;;
;;;                   File : class.scm                              ;;;
;;;                                                                 ;;;
;;;                 Amitabh Srivastava                              ;;;
;;;                                                                 ;;;
;;;         This file handles class creation.                       ;;;
;;;                                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;; 
(define %%class-tag '*class*)

(define %sc-make-class
  (lambda (name cv allivs mixins method-values)
    (let ((method-structure
                  (mapcar (lambda (a) (list (car a) (cons name name)))
                          method-values))
          (class (make-vector 15)))
       (vector-set! class 0 %%class-tag)
       (vector-set! class 1 name)
       (vector-set! class 2 cv)
       (vector-set! class 3 cv)
       (vector-set! class 4 allivs)
       (vector-set! class 5 mixins)
       (vector-set! class 6 (%uncompiled-make-instance class))
       (vector-set! class 9 method-structure)
       (vector-set! class 13 method-values)
       (vector-set! class 14 allivs)            
       class)))

(define %scoops-chk-class
  (lambda (class)
    (if (and (vector? class)
             (> (vector-length class) 0)
             (equal? %%class-tag (vector-ref class 0)))
	 class
         (error-handler class 6 #!TRUE))))


;;; 
(define (%sc-name class) (vector-ref class 1))
;;; 
(define (%sc-cv class) (vector-ref class 2))
;;; 
(define (%sc-allcvs class) (vector-ref class 3))
;;; 
(define (%sc-allivs class) (vector-ref class 4))
;;; 
(define (%sc-mixins class) (vector-ref class 5))
;;; 
(define (%sc-inst-template class) (vector-ref class 6))
;;; 
(define (%sc-method-env class) (vector-ref class 7))
;;;
(define (%sc-class-env class) (vector-ref class 8))
;;; 
(define (%sc-method-structure class) (vector-ref class 9))
;;; 
(define (%sc-subclasses class) (vector-ref class 10))
;;; 
(define (%sc-class-compiled class) (vector-ref class 11))
;;; 
(define (%sc-class-inherited class) (vector-ref class 12))
;;; 
(define (%sc-method-values class) (vector-ref class 13))
;;;
(define (%sc-iv class) (vector-ref class 14))


;;; 
(define (%sc-set-name class val) (vector-set! class 1 val))
;;; 
(define (%sc-set-cv class val) (vector-set! class 2 val))
;;; 
(define (%sc-set-allcvs class val) (vector-set! class 3 val))
;;; 
(define (%sc-set-allivs class val) (vector-set! class 4 val))
;;; 
(define (%sc-set-mixins class val) (vector-set! class 5 val))
;;; 
(define (%sc-set-inst-template class val) (vector-set! class 6 val))
;;; 
(define (%sc-set-method-env class val) (vector-set! class 7 val))
;;; 
(define (%sc-set-class-env class val) (vector-set! class 8 val))
;;; 
(define (%sc-set-method-structure class val) (vector-set! class 9 val))
;;; 
(define (%sc-set-subclasses class val) (vector-set! class 10 val))
;;; 
(define (%sc-set-class-compiled class val) (vector-set! class 11 val))
;;; 
(define (%sc-set-class-inherited class val) (vector-set! class 12 val))
;;; 
(define (%sc-set-method-values class val) (vector-set! class 13 val))
;;;
(define (%sc-set-iv class val) (vector-set! class 14 val))
;;;

(syntax-table-define system-global-syntax-table '%sc-name->class (macro e
    `(let* ((name ,(car e))
	    (class (eval name (the-environment))))
	(if (%scoops-chk-class class)
	      class
	      (error-handler name 2 #!true)))))
;;;

(define %sc-get-meth-value
  (lambda (meth-name class)
    (cdr (assq meth-name (%sc-method-values class)))))
;;;

(define %sc-get-cv-value
  (lambda (var class)
    (cadr (assq var (%sc-cv class)))))
;;;
 
(define %sc-concat
  (lambda (str sym)
    (string->symbol (string-append str (symbol->string sym)))))


