/*
 * strerr.c -- Implementation of ANSI C strerror (for brain-dead systems
 *             which don't have their own)
 *
 * (C) m.b (Matthias Blume); HUB; Nov 1993 PU/CS
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) strerr.c (C) M.Blume, Princeton University, 2.1"
 */

# ifdef sun

# include <string.h>

extern char *sys_errlist [];

char *strerror (int n)
{
  return sys_errlist [n];
}

# else

# include <stdio.h>
# include <string.h>

char *strerror (int num)
{
  static char buf [1024];

  sprintf
    (buf,
     "Error code %d\n"
     "[What you see here is a substitute for strerror at work.\n"
     " Complain to your system administration if you want the real thing!]",
     num);
  return buf;
}

# endif
