/*
 * except.h -- Declarations for Scheme exception handling
 *
 * (C) m.b (Matthias Blume); May 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) except.h (C) M.Blume, Princeton University, 2.2"
 */

# ifndef EXCEPT_H_
# define EXCEPT_H_

# include "noreturn.h"

/* Recoverable errors... (possibly triggered by Scheme constructs) */
extern void NORETURN error (const char *, ...) NRUTERON;
/* non-recoverable errors (finish Scheme's work) */
extern void NORETURN fatal (const char *) NRUTERON;
/* Recoverable error imposed by an implementation restriction */
extern void NORETURN restriction (const char *, ...) NRUTERON;
/* Warning messages */
extern void warning (const char *, ...);
/* Errors, which reset the system to some well-defined state */
extern void NORETURN reset (const char *) NRUTERON;

# endif
