/*
 * speccont.h -- Declarations for special primitive continuations
 *
 * (C) m.b (Matthias Blume); Jun 1992, HUB; Nov 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) speccont.h (C) M.Blume, Princeton University, 2.2"
 */

# if defined (SPECCONT_BUILTIN)

# define SPECCONT_HEADER	/* empty */
# define SPECCONT_TRAILER	/* empty */
# define SPECCONT(id,f,c,n,a) BUILTIN_CONT(f,c,n,a)

# elif !defined (SPECCONT_H_)

# define SPECCONT_H_

# define SPECCONT_HEADER	enum {
# define SPECCONT_TRAILER	SPECCONT_TERMINATOR };
# define SPECCONT(id,f,c,n,a)	id,

# else

# define SPECCONT_HEADER	/* empty */
# define SPECCONT_TRAILER	/* empty */
# define SPECCONT(id,f,c,a)	/* empty */

# endif

SPECCONT_HEADER
  SPECCONT (SCM_VM_TRAP_CONT,
	    ScmVMTrap, ScmVMTrapC, " -*-VM-TRAP-*-", -1)
  SPECCONT (SCM_VM_ERROR_CONT,
	    ScmVMError, ScmVMErrorC, " -*-VM-ERROR-*-", -1)
  SPECCONT (SCM_VM_GC_STRAT_CONT,
	    ScmVMGCStrategy, ScmVMGCStrategyC, " -*-VM-GC-STRATEGY-*-", -1)
  SPECCONT (SCM_VM_INTERRUPT_CONT,
	    ScmVMInterrupt, ScmVMInterruptC, " -*-VM-INTERRUP-*-", -1)
  SPECCONT (SCM_VM_COROUTINE_CONT,
	    ScmVMCoroutine, ScmVMCoroutineC, " -*-VM-COROUTINE-*-", -1)
  SPECCONT (SCM_VM_CW_VALUES_CONT,
	    ScmPrimCWValues, ScmPrimCWValuesC, "call-with-values", 2)
SPECCONT_TRAILER

# undef SPECCONT_HEADER
# undef SPECCONT_TRAILER
# undef SPECCONT
