(herald risc_bignum (env tsys))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

(define (set-bignum-length! bignum length)
  (lap ()
    (load l (d@r a1 -2) scratch)
    (sra ($ 8) scratch)			; length in bytes
    (sll ($ 2) scratch)
    (sub A2 scratch)                 ; size of bogus bytev including header
    (j= scratch zero %bignum-length-unchanged)
    (sub ($ 4) scratch)              ; bytev length
    (sll ($ 8) scratch)
    (or ($ header/bytev) scratch)  ; bogus bytev header
    (add a2 a1 vector)
    (store l scratch (d@r vector 2))
    (sll ($ 6) a2 scratch)
    (load ub (d@r A1 template/header) vector)
    (or vector scratch)
    (store l scratch (d@r A1 -2))
%bignum-length-unchanged
    (jr link-reg)
    (move ($ -2) NARGS)))


(define-constant bignum-positive? alt-bit-set?)


(define-constant bignum-negate!
  (primop bignum-negate! ()
    ((primop.side-effects? self) t)
    ((primop.generate self node)                               
     (let ((reg (->register node (leaf-value ((call-arg 2) node)))))
       (emit risc/load 'ub (reg-offset reg template/header) scratch)
       (emit risc/xor (machine-num #b10000000) scratch scratch)
       (emit risc/store 'b scratch (reg-offset reg template/header))))
    ((primop.type self node)
     '#[type (proc #f (proc #f top) bignum)])))

(define (%digit-divide x1 x0 y)   ; Divide x1x0 by y with x1 < (* 2 y)
  (lap ()
    (srl ($ 2) a1)
    (move A3 scratch)
    (srl ($ 2) scratch)
    (move zero a3)			;don't fool gc
    (move ($ 30) extra)
    (move zero vector)                ; Quotient in Vector
    (jbr integer-divide-start)

integer-divide-loop
    (sll ($ 1) vector)
    (j< a2 zero high-bit-set)
    (sll ($ 1) a2)
    (sll ($ 1) a1)
    (jbr integer-divide-start)
high-bit-set
    (sll ($ 1) a2)
    (sll ($ 1) a1)
    (or ($ 1) a1)
integer-divide-start
    (uj< a1 scratch integer-divide-next)
    (sub scratch a1)
    (or ($ 1) vector)
integer-divide-next
    (sub ($ 1) extra)
    (j>= extra zero integer-divide-loop)

    (sll ($ 2) a1)
    (move a1 A2)
    (sll ($ 2) Vector)
    (move Vector A1)
    (jr link-reg)
    (move ($ -3) nargs)))