(herald oload (env tsys))

(let ((oenv (make-locale standard-env 'orbit-env)))
  (*define standard-env 'orbit-env oenv)

  (*define t-implementation-env 'orbit-env oenv)

  (*define oenv 'load-orbit
    (lambda system
      (let ((machine (if (null? system) 
			 ((*value t-implementation-env 'machine-type)
			  ((*value t-implementation-env 'local-machine)))
			 (car system)))
            (processor (if (null? system) 
                           ((*value t-implementation-env 'processor-type)
                            ((*value t-implementation-env 'local-processor)))
                           (cadr system))))
        (load '(build orbit_files) oenv)
        (walk (lambda (f) (load f oenv)) (*value oenv '*orbit-files*))
        (walk (lambda (f) (load f oenv)) (*value oenv '*top-files*))
        (walk (lambda (f) (load f oenv)) (*value oenv '*front-files*))
	(xcase machine
	  ((pmax)
	   (*define oenv '*endian* 'little)
	   (load '(front_end pmaxfix) oenv)
	   (load-quietly '(t3_primops mipsconstants) oenv))
	  ((sparc)
	   (load '(front_end spfix) oenv)
	   (load-quietly '(t3_primops spconstants) oenv)))
        (walk (lambda (f) (load f oenv)) (*value oenv '*back-end-files*))
        (xcase processor
          ((mips)
           (walk (lambda (f) (load f oenv)) (*value oenv '*orbit-mips-files*))
           (walk (lambda (f) (load f oenv)) (*value oenv '*tas-mips-files*)))
          ((sparc)
           (walk (lambda (f) (load f oenv)) (*value oenv '*orbit-sparc-files*))
           (walk (lambda (f) (load f oenv)) (*value oenv '*tas-sparc-files*))))
        (xcase machine
	  ((pmax)
	   ((*value oenv 'orbit-mips-init) 't3_primops))
	  ((sparc)
	   ((*value oenv 'orbit-sparc-init) 't3_primops)))
        (*define t-implementation-env 'comfile (*value oenv 'comfile))
	(*define standard-env 'compile (*value oenv 'orbit))
        (walk (lambda (sym)
                (*define standard-env sym (*value oenv sym)))
              '(cl 
                listing
                orbit 
                comfile 
                compile-file 
                comfile2 
                tc-syntax-table
                make-empty-early-binding-locale
                )))))

    oenv)
